/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeManager;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={ChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={NextViewPermissionActionListener.class})})
public class UITaxonomyTreeMainForm
extends UIForm {
    public static final String FIELD_NAME = "TaxoTreeName";
    public static final String FIELD_WORKSPACE = "TaxoTreeWorkspace";
    public static final String FIELD_HOMEPATH = "TaxoTreeHomePath";

    public UITaxonomyTreeMainForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        UIFormSelectBox uiSelectWorkspace = new UIFormSelectBox(FIELD_WORKSPACE, FIELD_WORKSPACE, null);
        this.addChild((UIComponent)uiSelectWorkspace);
        uiSelectWorkspace.setOnChange("Change");
        UIFormInputSetWithAction uiActionHomePath = new UIFormInputSetWithAction("TaxonomyTreeHomePath");
        uiActionHomePath.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_HOMEPATH, FIELD_HOMEPATH, null).setReadOnly(true));
        uiActionHomePath.setActionInfo(FIELD_HOMEPATH, new String[]{"AddPath"});
        this.addUIComponentInput((UIComponent)uiActionHomePath);
        this.setActions(new String[]{"NextViewPermission", "Reset"});
    }

    public void update(TaxonomyTreeData taxonomyTree) throws Exception {
        String[] wsNames = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getWorkspaceNames();
        ArrayList<SelectItemOption> workspace = new ArrayList<SelectItemOption>();
        String systemWorkspace = ((UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class)).getSystemWorkspaceName();
        String dmsSystemWorkspace = ((UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class)).getDmsSystemWorkspaceName();
        for (String wsName : wsNames) {
            if (systemWorkspace.equals(wsName)) continue;
            workspace.add(new SelectItemOption(wsName, (Object)wsName));
        }
        if (taxonomyTree == null) {
            taxonomyTree = new TaxonomyTreeData();
        }
        Comparator<SelectItemOption<String>> comparator = new Comparator<SelectItemOption<String>>(this){

            @Override
            public int compare(SelectItemOption<String> option1, SelectItemOption<String> option2) {
                try {
                    return ((String)option1.getValue()).compareToIgnoreCase((String)option2.getValue());
                }
                catch (Exception ex) {
                    return 0;
                }
            }
        };
        Collections.sort(workspace, comparator);
        UIFormSelectBox uiSelectBox = this.getUIFormSelectBox(FIELD_WORKSPACE).setOptions(workspace);
        if (taxonomyTree.getTaxoTreeWorkspace() == null) {
            taxonomyTree.setTaxoTreeWorkspace(dmsSystemWorkspace);
        }
        uiSelectBox.setValue(taxonomyTree.getTaxoTreeWorkspace());
        UIFormInputBase inputName = (UIFormInputBase)this.findComponentById(FIELD_NAME);
        UIFormInputBase inputHomePath = (UIFormInputBase)this.findComponentById(FIELD_HOMEPATH);
        String treeName = taxonomyTree.getTaxoTreeName();
        TaxonomyTreeData taxonomyTreeData = ((UITaxonomyTreeContainer)this.getParent()).getTaxonomyTreeData();
        if (taxonomyTreeData == null || !taxonomyTreeData.isEdit()) {
            inputName.setValue((Object)treeName);
        } else {
            inputName.setValue((Object)taxonomyTreeData.getTaxoTreeName());
        }
        inputHomePath.setValue((Object)taxonomyTree.getTaxoTreeHomePath());
        this.getUIStringInput(FIELD_NAME).setReadOnly(false);
        if (taxonomyTree != null && taxonomyTree.isEdit() || taxonomyTreeData != null && taxonomyTreeData.isEdit()) {
            this.getUIStringInput(FIELD_NAME).setReadOnly(true);
        }
    }

    int checkForm() throws Exception {
        UIFormStringInput input = (UIFormStringInput)this.getChildById(FIELD_WORKSPACE);
        if (input == null || input.getValue() == null || ((String)input.getValue()).length() == 0) {
            return 1;
        }
        UIFormSelectBox selectBox = (UIFormSelectBox)this.getChildById(FIELD_WORKSPACE);
        UIFormInputBase inputHomePath = (UIFormInputBase)this.findComponentById(FIELD_HOMEPATH);
        String homePath = "";
        if (inputHomePath != null && inputHomePath.getValue() != null) {
            homePath = ((String)inputHomePath.getValue()).toString();
        }
        String dmsSysWorkspace = ((UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class)).getDmsSystemWorkspaceName();
        String workspace = (String)selectBox.getValue();
        if (homePath.length() == 0 && !dmsSysWorkspace.equals(workspace)) {
            return 2;
        }
        return 0;
    }

    public static class CancelActionListener
    extends EventListener<UITaxonomyTreeMainForm> {
        public void execute(Event<UITaxonomyTreeMainForm> event) throws Exception {
            UITaxonomyTreeMainForm uiTaxonomyTreeForm = (UITaxonomyTreeMainForm)((Object)event.getSource());
            UITaxonomyTreeContainer uiContainer = (UITaxonomyTreeContainer)uiTaxonomyTreeForm.getAncestorOfType(UITaxonomyTreeContainer.class);
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiContainer.getParent();
            uiPopupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupWindow);
        }
    }

    public static class ResetActionListener
    extends EventListener<UITaxonomyTreeMainForm> {
        public void execute(Event<UITaxonomyTreeMainForm> event) throws Exception {
            UITaxonomyTreeMainForm uiTaxonomyTreeForm = (UITaxonomyTreeMainForm)((Object)event.getSource());
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeForm.getAncestorOfType(UITaxonomyManagerTrees.class);
            uiTaxonomyTreeForm.getUIStringInput(UITaxonomyTreeMainForm.FIELD_NAME).setValue((Object)"");
            uiTaxonomyTreeForm.getUIStringInput(UITaxonomyTreeMainForm.FIELD_HOMEPATH).setValue((Object)"");
            uiTaxonomyTreeForm.update(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    public static class NextViewPermissionActionListener
    extends EventListener<UITaxonomyTreeMainForm> {
        public void execute(Event<UITaxonomyTreeMainForm> event) throws Exception {
            UITaxonomyTreeMainForm uiTaxonomyTreeMainForm = (UITaxonomyTreeMainForm)((Object)event.getSource());
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiTaxonomyTreeMainForm.getParent();
            TaxonomyTreeData taxonomyTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeContainer.getAncestorOfType(UITaxonomyManagerTrees.class);
            UIApplication uiApp = (UIApplication)uiTaxonomyTreeContainer.getAncestorOfType(UIApplication.class);
            int validateCode = uiTaxonomyTreeMainForm.checkForm();
            if (validateCode == 1) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeMainForm.msg.name-emty", null, 1));
                return;
            }
            if (validateCode == 2) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeMainForm.msg.homepath-emty", null, 1));
                return;
            }
            UIFormInputBase inputName = (UIFormInputBase)uiTaxonomyTreeMainForm.findComponentById(UITaxonomyTreeMainForm.FIELD_NAME);
            String name = ((String)inputName.getValue()).toString().trim();
            TaxonomyService taxonomyService = (TaxonomyService)uiTaxonomyTreeMainForm.getApplicationComponent(TaxonomyService.class);
            if (taxonomyService.hasTaxonomyTree(name) && !taxonomyTreeData.isEdit()) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeMainForm.msg.taxonomytree-existed", null, 1));
                return;
            }
            UIFormSelectBox selectBox = (UIFormSelectBox)uiTaxonomyTreeMainForm.getChildById(UITaxonomyTreeMainForm.FIELD_WORKSPACE);
            UIFormInputBase inputHomePath = (UIFormInputBase)uiTaxonomyTreeMainForm.findComponentById(UITaxonomyTreeMainForm.FIELD_HOMEPATH);
            String homePath = "";
            if (inputHomePath != null && inputHomePath.getValue() != null) {
                homePath = ((String)inputHomePath.getValue()).toString();
            }
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiTaxonomyTreeMainForm.getApplicationComponent(NodeHierarchyCreator.class);
            String treeDefinitionPath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesDefinitionPath");
            if (homePath.length() > 0 && treeDefinitionPath != null && treeDefinitionPath.length() > 0 && homePath.equals(treeDefinitionPath)) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeMainForm.msg.no-right-target-path", null, 1));
                return;
            }
            UIPermissionTreeManager uiPermissionManage = (UIPermissionTreeManager)uiTaxonomyTreeContainer.getChild(UIPermissionTreeManager.class);
            taxonomyTreeData.setTaxoTreeName(name);
            taxonomyTreeData.setTaxoTreeHomePath(homePath.trim());
            taxonomyTreeData.setTaxoTreeWorkspace((String)selectBox.getValue());
            uiTaxonomyTreeContainer.viewStep(2);
            uiPermissionManage.update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    public static class ChangeActionListener
    extends EventListener<UITaxonomyTreeMainForm> {
        public void execute(Event<UITaxonomyTreeMainForm> event) throws Exception {
            UITaxonomyTreeMainForm uiTaxonomyTreeMainForm = (UITaxonomyTreeMainForm)((Object)event.getSource());
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiTaxonomyTreeMainForm.getParent();
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeMainForm.getAncestorOfType(UITaxonomyManagerTrees.class);
            uiTaxonomyTreeMainForm.getUIStringInput(UITaxonomyTreeMainForm.FIELD_HOMEPATH).setValue((Object)"");
            TaxonomyTreeData taxonomyTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            UIFormSelectBox selectBox = (UIFormSelectBox)uiTaxonomyTreeMainForm.getChildById(UITaxonomyTreeMainForm.FIELD_WORKSPACE);
            taxonomyTreeData.setTaxoTreeHomePath("");
            taxonomyTreeData.setTaxoTreeWorkspace((String)selectBox.getValue());
            String dmsSysWorkspace = uiTaxonomyManagerTrees.getDmsSystemWorkspaceName();
            UIFormInputSetWithAction uiActionHomePath = (UIFormInputSetWithAction)uiTaxonomyTreeMainForm.getChildById("TaxonomyTreeHomePath");
            uiActionHomePath.removeChildById(UITaxonomyTreeMainForm.FIELD_HOMEPATH);
            if (!((String)selectBox.getValue()).equals(dmsSysWorkspace)) {
                uiActionHomePath.addUIFormInput((UIFormInput)new UIFormStringInput(UITaxonomyTreeMainForm.FIELD_HOMEPATH, UITaxonomyTreeMainForm.FIELD_HOMEPATH, null).addValidator(MandatoryValidator.class, new Object[0]).setReadOnly(true));
            } else {
                uiActionHomePath.addUIFormInput((UIFormInput)new UIFormStringInput(UITaxonomyTreeMainForm.FIELD_HOMEPATH, UITaxonomyTreeMainForm.FIELD_HOMEPATH, null).setReadOnly(true));
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    public static class AddPathActionListener
    extends EventListener<UITaxonomyTreeMainForm> {
        public void execute(Event<UITaxonomyTreeMainForm> event) throws Exception {
            UITaxonomyTreeMainForm uiTaxonomyTreeForm = (UITaxonomyTreeMainForm)((Object)event.getSource());
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeForm.getAncestorOfType(UITaxonomyManagerTrees.class);
            String workspace = (String)uiTaxonomyTreeForm.getUIFormSelectBox(UITaxonomyTreeMainForm.FIELD_WORKSPACE).getValue();
            uiTaxonomyManagerTrees.initPopupJCRBrowser(workspace, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }
}

