/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.services.attachments.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;

public class ShareAttachmentsToSpaceListener
extends Listener<Map<String, Object>, Space> {
    private static final Log LOG = ExoLogger.getLogger((String)ShareAttachmentsToSpaceListener.class.getName());
    private final RepositoryService repositoryService;
    private final SessionProviderService sessionProviderService;
    public static final String NEWS_ATTACHMENTS_IDS = "attachmentsIds";
    public static final String QUARANTINE = "/Quarantine/";
    public static final String CONTENT = "content";
    private static final String IMAGE_SRC_REGEX = "<img\\s+src=\"([^\"]*/portal/rest/(?:images|jcr)/repository/collaboration/[^\"]*)\"";

    public ShareAttachmentsToSpaceListener(RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    public void onEvent(Event event) throws Exception {
        Map source = (Map)event.getSource();
        List attachmentsIds = (List)source.get(NEWS_ATTACHMENTS_IDS);
        String content = (String)source.get(CONTENT);
        if (content != null) {
            attachmentsIds.addAll(this.extractImageAttachmentIdsFromContent(content));
        }
        Space space = (Space)event.getData();
        if (!CollectionUtils.isEmpty((Collection)attachmentsIds) && space != null) {
            for (String attachmentId : attachmentsIds) {
                try {
                    Session session = Utils.getSystemSession(this.sessionProviderService, this.repositoryService);
                    Node attachmentNode = session.getNodeByUUID(attachmentId);
                    if (attachmentNode.getPath().startsWith(QUARANTINE)) continue;
                    if (attachmentNode.canAddMixin("exo:privilegeable")) {
                        attachmentNode.addMixin("exo:privilegeable");
                    }
                    ((ExtendedNode)attachmentNode).setPermission("*:" + space.getGroupId(), new String[]{"read"});
                    attachmentNode.save();
                }
                catch (Exception e) {
                    LOG.error("Error while sharing attachment of id : {} to space: {}", new Object[]{attachmentId, space.getDisplayName(), e});
                }
            }
        }
    }

    private List<String> extractImageAttachmentIdsFromContent(String content) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        Matcher matcher = Pattern.compile(IMAGE_SRC_REGEX).matcher(content);
        while (matcher.find()) {
            String match = matcher.group(1);
            String attachmentNodeId = match.substring(match.lastIndexOf("/") + 1);
            attachmentIds.add(attachmentNodeId);
        }
        return attachmentIds;
    }
}

