/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.core.WebSchemaHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class WebSchemaConfigServiceImpl
implements WebSchemaConfigService,
Startable {
    private ConcurrentHashMap<String, WebSchemaHandler> webSchemaHandlers = new ConcurrentHashMap();
    private WCMConfigurationService wcmConfigService = WCMCoreUtils.getService(WCMConfigurationService.class);
    private static final Log LOG = ExoLogger.getLogger((String)WebSchemaConfigServiceImpl.class.getName());

    public WebSchemaConfigServiceImpl(WCMConfigurationService configurationService, NodeHierarchyCreator nodeHierarchyCreator) {
    }

    @Override
    public void addWebSchemaHandler(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof WebSchemaHandler) {
            String clazz = plugin.getClass().getName();
            this.webSchemaHandlers.putIfAbsent(clazz, (WebSchemaHandler)plugin);
        }
    }

    @Override
    public Collection<WebSchemaHandler> getAllWebSchemaHandler() throws Exception {
        return this.webSchemaHandlers.values();
    }

    @Override
    public <T extends WebSchemaHandler> T getWebSchemaHandlerByType(Class<T> clazz) {
        WebSchemaHandler schemaHandler = this.webSchemaHandlers.get(clazz.getName());
        if (schemaHandler == null) {
            return null;
        }
        return (T)((WebSchemaHandler)clazz.cast(schemaHandler));
    }

    @Override
    public void createSchema(SessionProvider sessionProvider, Node node) throws Exception {
        for (WebSchemaHandler handler : this.getAllWebSchemaHandler()) {
            if (!handler.matchHandler(sessionProvider, node)) continue;
            handler.onCreateNode(sessionProvider, node);
        }
    }

    @Override
    public void updateSchemaOnModify(SessionProvider sessionProvider, Node node) throws Exception {
        for (WebSchemaHandler handler : this.getAllWebSchemaHandler()) {
            if (!handler.matchHandler(sessionProvider, node)) continue;
            handler.onModifyNode(sessionProvider, node);
        }
    }

    @Override
    public void updateSchemaOnRemove(SessionProvider sessionProvider, Node node) throws Exception {
        for (WebSchemaHandler handler : this.getAllWebSchemaHandler()) {
            if (!handler.matchHandler(sessionProvider, node)) continue;
            handler.onRemoveNode(sessionProvider, node);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLiveSharePortalFolders() {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            for (NodeLocation locationEntry : this.wcmConfigService.getAllLivePortalsLocation()) {
                try {
                    String liveSharedPortalName;
                    ManageableRepository repository = WCMCoreUtils.getRepository();
                    Session session = sessionProvider.getSession(locationEntry.getWorkspace(), repository);
                    Node livePortalsStorage = (Node)session.getItem(locationEntry.getPath());
                    if (livePortalsStorage.hasNode(liveSharedPortalName = this.wcmConfigService.getSharedPortalName())) continue;
                    livePortalsStorage.addNode(liveSharedPortalName, "exo:portalFolder");
                    session.save();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error when try to create share portal folder", (Throwable)e);
                }
            }
        }
    }

    public void start() {
        LOG.info((Object)"Start WebSchemaConfigServiceImpl...");
        this.createLiveSharePortalFolders();
    }

    public void stop() {
    }
}

