/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.versions.UIDiff;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.VersionHistoryUtils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.pdfviewer.ObjectKey;
import org.exoplatform.services.pdfviewer.PDFViewerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/versions/UIVersionInfo.gtmpl", events={@EventConfig(listeners={SelectActionListener.class}), @EventConfig(listeners={RestoreVersionActionListener.class}, confirm="UIVersionInfo.msg.confirm-restore"), @EventConfig(listeners={CompareVersionActionListener.class}, csrfCheck=false), @EventConfig(listeners={DeleteVersionActionListener.class}, confirm="UIVersionInfo.msg.confirm-delete"), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={AddSummaryActionListener.class})})
public class UIVersionInfo
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)UIVersionInfo.class.getName());
    protected VersionNode rootVersion_;
    protected String rootOwner_;
    protected String rootVersionNum_;
    protected VersionNode curentVersion_;
    protected NodeLocation node_;
    private UIPageIterator uiPageIterator_;
    private List<VersionNode> listVersion = new ArrayList<VersionNode>();
    private static final String CACHE_NAME = "ecms.PDFViewerRestService";

    public UIVersionInfo() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)((UIPageIterator)this.addChild(UIPageIterator.class, null, "VersionInfoIterator")).setRendered(false);
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getListRecords() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateGrid() throws Exception {
        this.listVersion.clear();
        Node currentNode = this.getCurrentNode();
        this.curentVersion_ = this.rootVersion_ = new VersionNode(currentNode, currentNode.getSession());
        this.listVersion = this.getNodeVersions(this.getRootVersionNode().getChildren());
        VersionNode currentNodeTuple = new VersionNode(currentNode, currentNode.getSession());
        if (!this.listVersion.isEmpty()) {
            int lastVersionNum = Integer.parseInt(this.listVersion.get(0).getName());
            this.setRootVersionNum(String.valueOf(++lastVersionNum));
        } else {
            this.setRootVersionNum("1");
        }
        this.listVersion.add(0, currentNodeTuple);
        ListAccessImpl recordList = new ListAccessImpl(VersionNode.class, this.listVersion);
        LazyPageList dataPageList = new LazyPageList((ListAccess)recordList, 10);
        this.uiPageIterator_.setPageList((PageList)dataPageList);
    }

    public String getTitle(Node node) throws Exception {
        return Utils.getTitle((Node)node);
    }

    private boolean isRestoredVersions(List<VersionNode> list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                if (this.getVersionLabels(list.get(i)).length <= 0 || !this.isRestoredLabel(this.getVersionLabels(list.get(i))[0])) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean isRestoredLabel(String label) {
        try {
            String from = label.substring(label.indexOf("_") - 1).split("_")[0];
            String to = label.substring(label.indexOf("_") - 1).split("_")[1];
            Integer.parseInt(from);
            Integer.parseInt(to);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String[] getVersionLabels(VersionNode version) throws Exception {
        String[] labels;
        VersionHistory vH = NodeLocation.getNodeByLocation((NodeLocation)this.node_).getVersionHistory();
        if (StringUtils.isNotBlank((CharSequence)version.getName()) && !this.getRootVersionNum().equals(version.getName())) {
            Version versionNode = vH.getVersion(version.getName());
            labels = vH.getVersionLabels(versionNode);
        } else {
            labels = vH.getVersionLabels(vH.getRootVersion());
        }
        return labels;
    }

    public boolean isBaseVersion(VersionNode versionNode) throws Exception {
        if (!this.isRestoredVersions(this.listVersion)) {
            return this.isRootVersion(versionNode);
        }
        return versionNode.getPath().equals(this.getCurrentNode().getPath());
    }

    public boolean hasPermission(Node node) throws Exception {
        if (this.getCurrentNode().getPath().startsWith("/Groups/spaces")) {
            MembershipEntry mem = new MembershipEntry("/spaces/" + this.getCurrentNode().getPath().split("/")[3], "manager");
            return ConversationState.getCurrent().getIdentity().getMemberships().contains(mem) || ConversationState.getCurrent().getIdentity().getUserId().equals(node.getProperty("exo:lastModifier").getString());
        }
        return true;
    }

    public boolean isRootVersion(VersionNode versionNode) throws Exception {
        return versionNode.getUUID().equals(this.getCurrentNode().getUUID());
    }

    public VersionNode getRootVersionNode() throws Exception {
        return this.rootVersion_;
    }

    public String getRootOwner() throws Exception {
        return this.rootOwner_;
    }

    public void setRootOwner(String user) {
        this.rootOwner_ = user;
    }

    private List<VersionNode> getNodeVersions(List<VersionNode> children) throws Exception {
        List<VersionNode> child = new ArrayList();
        for (int i = 0; i < children.size(); ++i) {
            this.listVersion.add(children.get(i));
            child = children.get(i).getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        this.listVersion.sort(new Comparator<VersionNode>(this){

            @Override
            public int compare(VersionNode v1, VersionNode v2) {
                try {
                    if (Integer.parseInt(v1.getName()) < Integer.parseInt(v2.getName())) {
                        return 1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    return 0;
                }
            }
        });
        return this.listVersion;
    }

    public void activate() {
        try {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            if (this.node_ == null) {
                this.node_ = NodeLocation.getNodeLocationByNode((Node)uiExplorer.getCurrentNode());
            }
            this.updateGrid();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error!", (Throwable)e);
        }
    }

    public VersionNode getCurrentVersionNode() {
        return this.curentVersion_;
    }

    public Node getVersion(String versionName) throws RepositoryException {
        Node currentNode = this.getCurrentNode();
        if (StringUtils.isBlank((CharSequence)versionName) && StringUtils.isBlank((CharSequence)this.getCurrentVersionNode().getName()) || StringUtils.isNotBlank((CharSequence)versionName) && StringUtils.isNotBlank((CharSequence)this.getCurrentVersionNode().getName()) && this.getCurrentVersionNode().getName().equals(versionName)) {
            return currentNode;
        }
        for (VersionNode versionNode : this.listVersion) {
            if (!versionNode.getName().equals(versionName)) continue;
            return currentNode.getVersionHistory().getVersion(versionName);
        }
        return null;
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.node_);
    }

    public void setCurrentNode(Node node) {
        this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public List<VersionNode> getListVersion() {
        return this.listVersion;
    }

    public void setListVersion(List<VersionNode> listVersion) {
        this.listVersion = listVersion;
    }

    public String getLinkInDocumentsApp(String nodePath) throws Exception {
        DocumentService documentService = (DocumentService)WCMCoreUtils.getService(DocumentService.class);
        return documentService.getLinkInDocumentsApp(nodePath);
    }

    public void setRootVersionNum(String rootVersionNum) {
        this.rootVersionNum_ = rootVersionNum;
    }

    public String getRootVersionNum() {
        return this.rootVersionNum_;
    }

    private boolean isWebContent() throws Exception {
        Node currentNode = this.getCurrentNode();
        if (currentNode != null) {
            return currentNode.isNodeType("exo:webContent");
        }
        return false;
    }

    public static class AddSummaryActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            String currentVersionName = uiVersionInfo.curentVersion_.getName();
            if (StringUtils.isBlank((CharSequence)currentVersionName)) {
                currentVersionName = uiVersionInfo.getRootVersionNum();
            }
            String summary = event.getRequestContext().getRequestParameter("value") + "_" + currentVersionName;
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
            Node currentNode = uiExplorer.getCurrentNode();
            if (!Utils.isNameValid((String)summary, (String[])Utils.SPECIALCHARACTER)) {
                uiApp.addMessage(new ApplicationMessage("UILabelForm.msg.label-invalid", null, 1));
                return;
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)summary) && !currentNode.getVersionHistory().hasVersionLabel(summary)) {
                    String[] versionLabels;
                    Version currentVersion = null;
                    currentVersion = currentVersionName.equals(uiVersionInfo.getRootVersionNum()) ? currentNode.getVersionHistory().getRootVersion() : currentNode.getVersionHistory().getVersion(currentVersionName);
                    for (String label : versionLabels = currentNode.getVersionHistory().getVersionLabels(currentVersion)) {
                        currentNode.getVersionHistory().removeVersionLabel(label);
                    }
                    currentNode.getVersionHistory().addVersionLabel(currentVersion.getName(), summary, false);
                }
            }
            catch (VersionException ve) {
                uiApp.addMessage(new ApplicationMessage("UILabelForm.msg.label-exist", new Object[]{summary}));
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    public static class CloseActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                if (!uiChild.isRendered()) continue;
                uiChild.setRendered(false);
                return;
            }
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.updateAjax(event);
        }
    }

    public static class SelectActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            VersionNode selectedVersion;
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            String path = event.getRequestContext().getRequestParameter("objectId");
            VersionNode root = uiVersionInfo.getRootVersionNode();
            selectedVersion.setExpanded(!(selectedVersion = root.findVersionNode(path)).isExpanded());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
        }
    }

    public static class CompareVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiVersionInfo.getAncestorOfType(UIDocumentWorkspace.class);
            for (UIComponent uiChild : uiDocumentWorkspace.getChildren()) {
                uiChild.setRendered(false);
            }
            String fromVersionName = event.getRequestContext().getRequestParameter("versions").split(",")[0];
            String toVersionName = event.getRequestContext().getRequestParameter("versions").split(",")[1];
            UIDiff uiDiff = (UIDiff)uiDocumentWorkspace.getChild(UIDiff.class);
            uiDiff.setVersions(uiVersionInfo.getVersion(fromVersionName), uiVersionInfo.getVersion(toVersionName));
            uiDiff.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentWorkspace);
        }
    }

    public static class DeleteVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiVersionInfo.curentVersion_ = uiVersionInfo.getRootVersionNode().findVersionNode(objectId);
            Node node = uiVersionInfo.getCurrentNode();
            UIApplication app = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
            try {
                node.getSession().save();
                node.getSession().refresh(false);
                VersionHistoryUtils.removeVersion((Node)uiVersionInfo.getCurrentNode(), (String)uiVersionInfo.curentVersion_.getName());
                uiVersionInfo.curentVersion_ = uiVersionInfo.rootVersion_ = new VersionNode(node, uiExplorer.getSession());
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                uiExplorer.getSession().save();
                uiVersionInfo.activate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
            }
            catch (ReferentialIntegrityException rie) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)rie);
                }
                app.addMessage(new ApplicationMessage("UIVersionInfo.msg.error-removing-referenced-version", null, 0));
                return;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                }
                app.addMessage(new ApplicationMessage("UIVersionInfo.msg.error-removing-version", null, 0));
                return;
            }
        }
    }

    public static class RestoreVersionActionListener
    extends EventListener<UIVersionInfo> {
        public void execute(Event<UIVersionInfo> event) throws Exception {
            UIVersionInfo uiVersionInfo = (UIVersionInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiVersionInfo.getAncestorOfType(UIJCRExplorer.class);
            PDFViewerService pdfViewerService = (PDFViewerService)WCMCoreUtils.getService(PDFViewerService.class);
            CacheService caService = (CacheService)WCMCoreUtils.getService(CacheService.class);
            ExoCache pdfCache = pdfViewerService != null ? pdfViewerService.getCache() : caService.getCacheInstance(UIVersionInfo.CACHE_NAME);
            for (UIComponent uiChild : uiVersionInfo.getChildren()) {
                uiChild.setRendered(false);
            }
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            VersionNode currentVersionNode = uiVersionInfo.rootVersion_.findVersionNode(objectId);
            String fromVersionName = currentVersionNode.getName();
            UIApplication uiApp = (UIApplication)uiVersionInfo.getAncestorOfType(UIApplication.class);
            Node currentNode = uiVersionInfo.getCurrentNode();
            uiExplorer.addLockToken(currentNode);
            try {
                if (!currentNode.isCheckedOut()) {
                    currentNode.checkout();
                }
                AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
                Version addedVersion = autoVersionService.autoVersion(currentNode);
                currentNode.restore(fromVersionName, true);
                if (!currentNode.isCheckedOut()) {
                    currentNode.checkout();
                }
                StringBuilder bd = new StringBuilder();
                bd.append(((ManageableRepository)currentNode.getSession().getRepository()).getConfiguration().getName()).append("/").append(currentNode.getSession().getWorkspace().getName()).append("/").append(currentNode.getUUID());
                StringBuilder bd1 = new StringBuilder().append((CharSequence)bd).append("/jcr:lastModified");
                StringBuilder bd2 = new StringBuilder().append((CharSequence)bd).append("/jcr:baseVersion");
                pdfCache.remove((Serializable)new ObjectKey(bd.toString()));
                pdfCache.remove((Serializable)new ObjectKey(bd1.toString()));
                pdfCache.remove((Serializable)new ObjectKey(bd2.toString()));
                int lastVersionIndice = Integer.parseInt(addedVersion.getName());
                String restoredFromMsg = "UIDiff.label.restoredFrom_" + fromVersionName + "_" + (lastVersionIndice + 1);
                VersionHistory versionHistory = currentNode.getVersionHistory();
                versionHistory.addVersionLabel(versionHistory.getRootVersion().getName(), restoredFromMsg, false);
                ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
                try {
                    if (listenerService != null && activityService != null && activityService.isAcceptedNode(currentNode)) {
                        listenerService.broadcast(ActivityCommonService.NODE_REVISION_CHANGED, (Object)currentNode, (Object)fromVersionName);
                    }
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Can not notify NodeMovedActivity: " + e.getMessage()));
                    }
                }
            }
            catch (JCRInvalidItemStateException invalid) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                LOG.error((Object)"Unable to restore version", (Throwable)invalid);
                return;
            }
            catch (NullPointerException nuException) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                LOG.error((Object)"Unable to restore version", (Throwable)nuException);
                return;
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIVersionInfo.msg.invalid-item-state", null, 1));
                LOG.error((Object)"Unable to restore version", (Throwable)e);
                return;
            }
            uiVersionInfo.activate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiVersionInfo);
            uiExplorer.setIsHidePopup(true);
        }
    }
}

