/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.fckeditor;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.ecm.connector.fckeditor.FCKMessage;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileUploadHandler {
    public static final String UPLOAD_ACTION = "upload";
    public static final String PROGRESS_ACTION = "progress";
    public static final String ABORT_ACTION = "abort";
    public static final String DELETE_ACTION = "delete";
    public static final String SAVE_ACTION = "save";
    private UploadService uploadService = (UploadService)WCMCoreUtils.getService(UploadService.class);
    private FCKMessage fckMessage = new FCKMessage();

    public FileUploadHandler(ExoContainer container) {
    }

    public Response upload(HttpServletRequest servletRequest) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        this.uploadService.createUploadResource(servletRequest);
        return Response.ok(null, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).build();
    }

    public Response control(String uploadId, String action) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        if (PROGRESS_ACTION.equals(action)) {
            Document currentProgress = this.getProgress(uploadId);
            return Response.ok((Object)currentProgress, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        if (ABORT_ACTION.equals(action)) {
            this.uploadService.removeUploadResource(uploadId);
            return Response.ok(null, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        if (DELETE_ACTION.equals(action)) {
            this.uploadService.removeUploadResource(uploadId);
            return Response.ok(null, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        return Response.status((int)400).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    public Response saveAsNTFile(Node parent, String uploadId, String fileName, String language) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        UploadResource resource = this.uploadService.getUploadResource(uploadId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        if (parent == null) {
            Document fileNotUploaded = this.fckMessage.createMessage(204, "Error", language, null);
            return Response.ok((Object)fileNotUploaded, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        if (!FCKUtils.hasAddNodePermission(parent)) {
            Object[] args = new Object[]{parent.getPath()};
            Document message = this.fckMessage.createMessage(203, "Error", language, args);
            return Response.ok((Object)message, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        if (fileName == null || fileName.length() == 0) {
            fileName = resource.getFileName();
        }
        if (parent.hasNode(fileName)) {
            Object[] args = new Object[]{fileName, parent.getPath()};
            Document fileExisted = this.fckMessage.createMessage(201, "Error", language, args);
            return Response.ok((Object)fileExisted, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        String location = resource.getStoreLocation();
        byte[] uploadData = IOUtil.getFileContentAsBytes((String)location);
        Node file = parent.addNode(fileName, "nt:file");
        Node jcrContent = file.addNode("jcr:content", "nt:resource");
        String mimetype = DMSMimeTypeResolver.getInstance().getMimeType(resource.getFileName());
        jcrContent.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(uploadData));
        jcrContent.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        jcrContent.setProperty("jcr:mimeType", mimetype);
        parent.save();
        this.uploadService.removeUploadResource(uploadId);
        return Response.ok(null, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    private Document getProgress(String uploadId) throws Exception {
        UploadResource resource = this.uploadService.getUploadResource(uploadId);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        if (resource == null) {
            return doc;
        }
        Double percent = 0.0;
        percent = resource.getStatus() == 0 ? Double.valueOf(resource.getUploadedSize() * 100.0 / resource.getEstimatedSize()) : Double.valueOf(100.0);
        Element rootElement = doc.createElement("UploadProgress");
        rootElement.setAttribute("uploadId", uploadId);
        rootElement.setAttribute("fileName", resource.getFileName());
        rootElement.setAttribute("percent", "" + percent.intValue());
        doc.appendChild(rootElement);
        return doc;
    }
}

