/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UIUploadInput;
import org.exoplatform.webui.form.validator.Validator;

public class UploadFileMimeTypesValidator
implements Validator {
    private String mimeTypes_;

    public UploadFileMimeTypesValidator() {
    }

    public UploadFileMimeTypesValidator(String mimeTypes) {
        this.mimeTypes_ = mimeTypes;
    }

    public void validate(UIFormInput uiInput) throws Exception {
        if (uiInput instanceof UIUploadInput) {
            String uploadId;
            String mimeTypeInput;
            UIUploadInput uploadInput = (UIUploadInput)UIUploadInput.class.cast(uiInput);
            String string = mimeTypeInput = uploadInput.getUploadResource(uploadId = uploadInput.getUploadIds()[0]) == null ? null : uploadInput.getUploadResource(uploadId).getMimeType();
            if (this.mimeTypes_ != null && mimeTypeInput != null) {
                if (this.mimeTypes_.contains(mimeTypeInput)) {
                    return;
                }
                Pattern pattern = Pattern.compile(this.mimeTypes_.replace("*", ".*"));
                Matcher matcher = pattern.matcher(mimeTypeInput);
                if (!matcher.find()) {
                    Object[] args = new Object[]{mimeTypeInput, uploadInput.getName()};
                    throw new MessageException(new ApplicationMessage("UploadFileMimeTypesValidator.msg.wrong-mimetype", args, 1));
                }
            }
        }
    }
}

