/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.cms.thumbnail.impl.ThumbnailUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/thumbnailImage/")
public class ThumbnailRESTService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)ThumbnailRESTService.class.getName());
    public static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    public static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private final RepositoryService repositoryService_;
    private final ThumbnailService thumbnailService_;
    private final NodeFinder nodeFinder_;
    private final LinkManager linkManager_;

    public ThumbnailRESTService(RepositoryService repositoryService, ThumbnailService thumbnailService, NodeFinder nodeFinder, LinkManager linkManager) {
        this.repositoryService_ = repositoryService;
        this.thumbnailService_ = thumbnailService;
        this.nodeFinder_ = nodeFinder;
        this.linkManager_ = linkManager;
    }

    @Path(value="/medium/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getThumbnailImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        Node imageNode = this.getShowingNode(workspaceName, nodePath);
        return this.getThumbnailByType(imageNode, "exo:mediumSize", ifModifiedSince);
    }

    @Path(value="/big/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getCoverImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        Node imageNode = this.getShowingNode(workspaceName, nodePath);
        return this.getThumbnailByType(imageNode, "exo:bigSize", ifModifiedSince);
    }

    @Path(value="/large/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getLargeImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        Node imageNode = this.getShowingNode(workspaceName, nodePath);
        return this.getThumbnailByType(imageNode, "exo:bigSize", ifModifiedSince);
    }

    @Path(value="/small/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getSmallImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        Node imageNode = this.getShowingNode(workspaceName, nodePath);
        return this.getThumbnailByType(imageNode, "exo:smallSize", ifModifiedSince);
    }

    @Path(value="/custom/{size}/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getCustomImage(@PathParam(value="size") String size, @PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        Node imageNode = this.getShowingNode(workspaceName, nodePath);
        return this.getThumbnailByType(imageNode, "exo:" + size, ifModifiedSince);
    }

    @Path(value="/custom/{size}/{workspaceName}/{identifier}")
    @GET
    public Response getCustomImage(@PathParam(value="size") String size, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="identifier") String identifier, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspaceName, SessionProviderService.getRepository());
        Node imageNode = ((ExtendedSession)session).getNodeByIdentifier(identifier);
        return this.getThumbnailByType(imageNode, "exo:" + size, ifModifiedSince);
    }

    @Path(value="/origin/{repoName}/{workspaceName}/{nodePath:.*}/")
    @GET
    public Response getOriginImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="nodePath") String nodePath, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (!this.thumbnailService_.isEnableThumbnail()) {
            return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        Node showingNode = this.getShowingNode(workspaceName, nodePath);
        Node targetNode = this.getTargetNode(showingNode);
        if (targetNode.isNodeType("nt:file") || targetNode.isNodeType("nt:resource")) {
            Node content = targetNode;
            if (targetNode.isNodeType("nt:file")) {
                content = targetNode.getNode("jcr:content");
            }
            if (ifModifiedSince != null) {
                Date ifModifiedSinceDate = dateFormat.parse(ifModifiedSince);
                Date lastModifiedDate = content.getProperty("jcr:lastModified").getDate().getTime();
                if (ifModifiedSinceDate.getTime() >= lastModifiedDate.getTime()) {
                    return Response.notModified().build();
                }
            }
            String mimeType = content.getProperty("jcr:mimeType").getString();
            for (ComponentPlugin plugin : this.thumbnailService_.getComponentPlugins()) {
                ThumbnailPlugin thumbnailPlugin;
                if (!(plugin instanceof ThumbnailPlugin) || !(thumbnailPlugin = (ThumbnailPlugin)plugin).getMimeTypes().contains(mimeType)) continue;
                InputStream inputStream = content.getProperty("jcr:data").getStream();
                return Response.ok((Object)inputStream, (String)"image").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
        }
        return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private Response getThumbnailByType(Node imageNode, String propertyName, String ifModifiedSince) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (!this.thumbnailService_.isEnableThumbnail()) {
            return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        Node targetNode = this.getTargetNode(imageNode);
        Node parentNode = null;
        try {
            parentNode = imageNode.getParent();
        }
        catch (AccessDeniedException e) {
            Session session = imageNode.getSession();
            parentNode = session.getItem(imageNode.getPath()).getParent();
        }
        if (targetNode.isNodeType("nt:file")) {
            Node content = targetNode.getNode("jcr:content");
            String mimeType = content.getProperty("jcr:mimeType").getString();
            for (ComponentPlugin plugin : this.thumbnailService_.getComponentPlugins()) {
                ThumbnailPlugin thumbnailPlugin;
                if (!(plugin instanceof ThumbnailPlugin) || !(thumbnailPlugin = (ThumbnailPlugin)plugin).getMimeTypes().contains(mimeType)) continue;
                Node thumbnailFolder = ThumbnailUtils.getThumbnailFolder((Node)parentNode);
                Node thumbnailNode = ThumbnailUtils.getThumbnailNode((Node)thumbnailFolder, (String)((NodeImpl)imageNode).getIdentifier());
                if (!thumbnailNode.hasProperty(propertyName)) {
                    try {
                        BufferedImage image = thumbnailPlugin.getBufferedImage(content, targetNode.getPath());
                        this.thumbnailService_.addThumbnailImage(thumbnailNode, image, propertyName);
                    }
                    catch (UnsatisfiedLinkError e) {
                        LOG.error((Object)("Failed to get image: " + e.getMessage()), (Throwable)e);
                        return Response.serverError().entity((Object)e.getMessage()).build();
                    }
                }
                if (ifModifiedSince != null && thumbnailNode.hasProperty("exo:thumbnailLastModified")) {
                    Date ifModifiedSinceDate = dateFormat.parse(ifModifiedSince);
                    Date lastModifiedDate = thumbnailNode.getProperty("exo:thumbnailLastModified").getDate().getTime();
                    if (ifModifiedSinceDate.getTime() >= lastModifiedDate.getTime()) {
                        return Response.notModified().build();
                    }
                }
                InputStream inputStream = null;
                if (thumbnailNode.hasProperty(propertyName)) {
                    inputStream = thumbnailNode.getProperty(propertyName).getStream();
                }
                return Response.ok(inputStream, (String)"image").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
        }
        return this.getThumbnailRes(parentNode, ((NodeImpl)imageNode).getIdentifier(), propertyName, ifModifiedSince);
    }

    private Response getThumbnailRes(Node parentNode, String identifier, String propertyName, String ifModifiedSince) throws Exception {
        Node thumbnailFolder;
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (parentNode.hasNode("exo:thumbnails") && (thumbnailFolder = parentNode.getNode("exo:thumbnails")).hasNode(identifier)) {
            Node thumbnailNode = thumbnailFolder.getNode(identifier);
            if (ifModifiedSince != null && thumbnailNode.hasProperty("exo:dateModified")) {
                Date ifModifiedSinceDate = dateFormat.parse(ifModifiedSince);
                Date lastModifiedDate = thumbnailNode.getProperty("exo:dateModified").getDate().getTime();
                if (ifModifiedSinceDate.getTime() >= lastModifiedDate.getTime()) {
                    return Response.notModified().build();
                }
            }
            if (thumbnailNode.hasProperty(propertyName)) {
                InputStream inputStream = thumbnailNode.getProperty(propertyName).getStream();
                return Response.ok((Object)inputStream, (String)"image").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
        }
        return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private String getNodePath(String nodePath) throws Exception {
        ArrayList<String> encodeNameArr = new ArrayList<String>();
        if (!nodePath.equals("/")) {
            for (String name : nodePath.split("/")) {
                if (name.length() <= 0) continue;
                encodeNameArr.add(Text.escapeIllegalJcrChars((String)name));
            }
            StringBuilder encodedPath = new StringBuilder();
            for (String encodedName : encodeNameArr) {
                encodedPath.append("/").append(encodedName);
            }
            nodePath = encodedPath.toString();
        }
        return nodePath;
    }

    private Node getTargetNode(Node showingNode) throws Exception {
        Node targetNode = null;
        if (this.linkManager_.isLink((Item)showingNode)) {
            try {
                targetNode = this.linkManager_.getTarget(showingNode);
            }
            catch (ItemNotFoundException e) {
                targetNode = showingNode;
            }
        } else {
            targetNode = showingNode;
        }
        return targetNode;
    }

    private Node getShowingNode(String workspaceName, String nodePath) throws Exception {
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspaceName, SessionProviderService.getRepository());
        if (((String)nodePath).equals("/")) {
            return session.getRootNode();
        }
        if (!((String)nodePath).startsWith("/")) {
            nodePath = "/" + (String)nodePath;
        }
        try {
            return (Node)this.nodeFinder_.getItem(session, (String)nodePath);
        }
        catch (PathNotFoundException e) {
            try {
                return (Node)this.nodeFinder_.getItem(session, this.getNodePath((String)nodePath));
            }
            catch (PathNotFoundException e1) {
                return null;
            }
        }
    }
}

