/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICCBased
extends PColorSpace {
    private static final Logger logger = Logger.getLogger(ICCBased.class.toString());
    public static final Name ICCBASED_KEY = new Name("ICCBased");
    public static final Name N_KEY = new Name("N");
    int numcomp;
    PColorSpace alternate;
    Stream stream;
    ColorSpace colorSpace;
    private static ConcurrentHashMap<Integer, Color> iccColorCache3B;
    private static ConcurrentHashMap<Integer, Color> iccColorCache4B;
    private boolean failed;

    public ICCBased(Library l, Stream h) {
        super(l, h.getEntries());
        iccColorCache3B = new ConcurrentHashMap();
        iccColorCache4B = new ConcurrentHashMap();
        this.numcomp = h.getInt(N_KEY);
        switch (this.numcomp) {
            case 1: {
                this.alternate = new DeviceGray(l, null);
                break;
            }
            case 3: {
                this.alternate = new DeviceRGB(l, null);
                break;
            }
            case 4: {
                this.alternate = new DeviceCMYK(l, null);
            }
        }
        this.stream = h;
    }

    @Override
    public synchronized void init() {
        if (this.inited) {
            return;
        }
        try {
            this.stream.init();
            byte[] in = this.stream.getDecodedStreamBytes(0);
            if (logger.isLoggable(Level.FINEST)) {
                String content = Utils.convertByteArrayToByteString(in);
                logger.finest("Content = " + content);
            }
            if (in != null) {
                ICC_Profile profile = ICC_Profile.getInstance(in);
                this.colorSpace = new ICC_ColorSpace(profile);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error Processing ICCBased Colour Profile", e);
        }
        this.inited = true;
    }

    public PColorSpace getAlternate() {
        return this.alternate;
    }

    private static int generateKey(float[] f) {
        int key = ((int)(f[0] * 255.0f) & 0xFF) << 16 | ((int)(f[1] * 255.0f) & 0xFF) << 8 | (int)(f[2] * 255.0f) & 0xFF & 0xFF;
        if (f.length == 4) {
            key |= ((int)(f[3] * 255.0f) & 0xFF) << 24;
        }
        return key;
    }

    private static Color addColorToCache(ConcurrentHashMap<Integer, Color> iccColorCache, int key, ColorSpace colorSpace, float[] f) {
        Color color = iccColorCache.get(key);
        if (color != null) {
            return color;
        }
        color = new Color(ICCBased.calculateColor(f, colorSpace));
        iccColorCache.put(key, color);
        return color;
    }

    @Override
    public Color getColor(float[] f, boolean fillAndStroke) {
        this.init();
        if (this.colorSpace != null && !this.failed) {
            try {
                int key = ICCBased.generateKey(f);
                if (f.length <= 3) {
                    return ICCBased.addColorToCache(iccColorCache3B, key, this.colorSpace, f);
                }
                return ICCBased.addColorToCache(iccColorCache4B, key, this.colorSpace, f);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error getting ICCBased colour", e);
                this.failed = true;
            }
        }
        return this.alternate.getColor(f);
    }

    private static int calculateColor(float[] f, ColorSpace colorSpace) {
        int n = colorSpace.getNumComponents();
        float[] fvalue = new float[n];
        int fLength = f.length;
        int toCopy = n;
        if (fLength < toCopy) {
            toCopy = fLength;
        }
        for (int i = 0; i < toCopy; ++i) {
            float curr = f[fLength - 1 - i];
            if (curr < 0.0f) {
                curr = 0.0f;
            } else if (curr > 1.0f) {
                curr = 1.0f;
            }
            fvalue[i] = curr;
        }
        float[] frgbvalue = colorSpace.toRGB(fvalue);
        return 0xFF000000 | ((int)(frgbvalue[0] * 255.0f) & 0xFF) << 16 | ((int)(frgbvalue[1] * 255.0f) & 0xFF) << 8 | (int)(frgbvalue[2] * 255.0f) & 0xFF;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public int getNumComponents() {
        return this.numcomp;
    }
}

