/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.document.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;
import org.picocontainer.Startable;

public class ShareDocumentService
implements IShareDocumentService,
Startable {
    private static final String SHARED_TEMPLATE_PARAMS_PREFIX = "Shared_";
    private static final Log LOG = ExoLogger.getLogger(ShareDocumentService.class);
    public static final String MIX_PRIVILEGEABLE = "exo:privilegeable";
    private static final boolean POST_ACTIVITY = true;
    public static final String ID = "id";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String WORKSPACE = "WORKSPACE";
    public static final String DOCPATH = "DOCPATH";
    public static final String NODEPATH_NAME = "nodePath";
    public static final String REPOSITORY_NAME = "repository";
    public static final String WORKSPACE_NAME = "collaboration";
    private SessionProviderService sessionProviderService;
    private LinkManager linkManager;
    private SpaceService spaceService;
    private RepositoryService repoService;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private static final String TEMPLATE_PARAMS_SEPARATOR = "|@|";

    public ShareDocumentService(RepositoryService repositoryService, LinkManager linkManager, IdentityManager identityManager, ActivityManager activityManager, SpaceService spaceService, SessionProviderService sessionProviderService) {
        this.repoService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.linkManager = linkManager;
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    @Override
    public String publishDocumentToSpace(String space, Node currentNode, String comment, String perm) {
        return this.publishDocumentToSpace(space, currentNode, comment, perm, true);
    }

    @Override
    public String publishDocumentToSpace(String space, Node currentNode, String comment, String perm, Boolean postActivity) {
        block14: {
            Node rootSpace = null;
            Node shared = null;
            try {
                Node link;
                block13: {
                    String tempPerms;
                    SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                    ManageableRepository repository = this.repoService.getCurrentRepository();
                    Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                    NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
                    nodeCreator.getJcrPath("groupsPath");
                    rootSpace = (Node)session.getItem(nodeCreator.getJcrPath("groupsPath") + space);
                    rootSpace = rootSpace.getNode("Documents");
                    shared = !rootSpace.hasNode("Shared") ? rootSpace.addNode("Shared") : rootSpace.getNode("Shared");
                    if (currentNode.isNodeType("exo:symlink")) {
                        currentNode = this.linkManager.getTarget(currentNode);
                    }
                    if (!(tempPerms = perm.toString()).equals("read")) {
                        tempPerms = "read,add_node,set_property,remove";
                    }
                    if (PermissionUtil.canChangePermission((Node)currentNode)) {
                        this.setSpacePermission(currentNode, space, tempPerms.split(","));
                    } else if (PermissionUtil.canRead((Node)currentNode)) {
                        SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
                        Session systemSession = systemSessionProvider.getSession(session.getWorkspace().getName(), repository);
                        Node _node = (Node)systemSession.getItem(currentNode.getPath());
                        this.setSpacePermission(_node, space, tempPerms.split(","));
                    }
                    currentNode.getSession().save();
                    link = this.linkManager.createLink(shared, currentNode);
                    String nodeMimeType = org.exoplatform.wcm.ext.component.activity.listener.Utils.getMimeType(currentNode);
                    link.addMixin("mix:fileType");
                    link.setProperty("exo:fileType", nodeMimeType);
                    rootSpace.save();
                    if (postActivity.booleanValue()) {
                        try {
                            ExoSocialActivity activity = null;
                            activity = currentNode.getPrimaryNodeType().getName().equals("nt:file") ? org.exoplatform.wcm.ext.component.activity.listener.Utils.createShareActivity(link, "", "sharefiles:spaces", comment, perm) : org.exoplatform.wcm.ext.component.activity.listener.Utils.createShareActivity(link, "", "sharecontents:spaces", comment, perm);
                            link.save();
                            return activity.getId();
                        }
                        catch (Exception e1) {
                            if (!LOG.isErrorEnabled()) break block13;
                            LOG.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
                if (link.canAddMixin("mix:referenceable")) {
                    link.addMixin("mix:referenceable");
                    link.save();
                    return link.getUUID();
                }
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block14;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public void publishDocumentToUser(String user, Node currentNode, String comment, String perm) {
        block9: {
            Node userPrivateNode = null;
            Node shared = null;
            try {
                String tempPerms;
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                ManageableRepository repository = this.repoService.getCurrentRepository();
                Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                userPrivateNode = this.getPrivateUserNode(sessionProvider, user);
                userPrivateNode = userPrivateNode.getNode("Documents");
                shared = !userPrivateNode.hasNode("Shared") ? userPrivateNode.addNode("Shared") : userPrivateNode.getNode("Shared");
                if (currentNode.isNodeType("exo:symlink")) {
                    currentNode = this.linkManager.getTarget(currentNode);
                }
                if (!(tempPerms = perm.toString()).equals("read")) {
                    tempPerms = "read,add_node,set_property,remove";
                }
                if (PermissionUtil.canChangePermission((Node)currentNode)) {
                    this.setUserPermission(currentNode, user, tempPerms.split(","));
                } else if (PermissionUtil.canRead((Node)currentNode)) {
                    SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
                    Session systemSession = systemSessionProvider.getSession(session.getWorkspace().getName(), repository);
                    Node _node = (Node)systemSession.getItem(currentNode.getPath());
                    this.setUserPermission(_node, user, tempPerms.split(","));
                }
                currentNode.getSession().save();
                Node link = this.linkManager.createLink(shared, currentNode);
                String nodeMimeType = org.exoplatform.wcm.ext.component.activity.listener.Utils.getMimeType(currentNode);
                link.addMixin("mix:fileType");
                link.setProperty("exo:fileType", nodeMimeType);
                userPrivateNode.save();
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Node getPrivateUserNode(SessionProvider sessionProvider, String user) throws Exception, PathNotFoundException, RepositoryException {
        NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
        String privateRelativePath = nodeCreator.getJcrPath("userPrivate");
        Node userNode = nodeCreator.getUserNode(sessionProvider, user);
        return userNode.getNode(privateRelativePath);
    }

    @Override
    public void unpublishDocumentToUser(String user, ExtendedNode node) {
        block4: {
            Node userPrivateNode = null;
            Node sharedNode = null;
            try {
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                userPrivateNode = this.getPrivateUserNode(sessionProvider, user);
                userPrivateNode = userPrivateNode.getNode("Documents");
                sharedNode = userPrivateNode.getNode("Shared");
                sharedNode.getNode(node.getName()).remove();
                this.removeUserPermission(node, user);
                node.getSession().save();
                userPrivateNode.save();
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void unpublishDocumentToSpace(String space, ExtendedNode node) {
        block5: {
            Node rootSpace = null;
            Node sharedNode = null;
            try {
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                ManageableRepository repository = this.repoService.getCurrentRepository();
                Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
                rootSpace = (Node)session.getItem(nodeCreator.getJcrPath("groupsPath") + space);
                rootSpace = rootSpace.getNode("Documents");
                if (rootSpace.hasNode("Shared")) {
                    sharedNode = rootSpace.getNode("Shared");
                    sharedNode.getNode(node.getName()).remove();
                    rootSpace.save();
                }
                this.removeSpacePermission(node, space);
                node.getSession().save();
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void shareDocumentActivityToSpace(ExoSocialActivity sharedActivity) throws Exception {
        if (sharedActivity == null) {
            throw new IllegalArgumentException("activity is mandarory");
        }
        if (sharedActivity.isComment() || sharedActivity.getActivityStream() == null) {
            throw new IllegalArgumentException("comment is not allowed");
        }
        String sharedActivityId = sharedActivity.getId();
        String originalActivityId = (String)sharedActivity.getTemplateParams().get("originalActivityId");
        String spacePrettyName = sharedActivity.getActivityStream().getPrettyId();
        Space targetSpace = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        Identity targetSpaceIdentity = this.identityManager.getOrCreateSpaceIdentity(spacePrettyName);
        Identity posterIdentity = this.identityManager.getIdentity(sharedActivity.getPosterId());
        String posterUsername = posterIdentity.getRemoteId();
        if (targetSpaceIdentity != null && SpaceUtils.isSpaceManagerOrSuperManager((String)posterUsername, (String)targetSpace.getGroupId()) || this.spaceService.isMember(targetSpace, posterUsername) && SpaceUtils.isRedactor((String)posterUsername, (String)targetSpace.getGroupId())) {
            Map originalActivityTemplateParams = this.activityManager.getActivity(originalActivityId).getTemplateParams();
            String[] originalActivityFilesWorkspaces = this.getParameterValues(originalActivityTemplateParams, WORKSPACE);
            if (originalActivityFilesWorkspaces == null) {
                originalActivityFilesWorkspaces = this.getParameterValues(originalActivityTemplateParams, WORKSPACE_NAME);
            }
            if (originalActivityFilesWorkspaces == null || originalActivityFilesWorkspaces.length == 0) {
                LOG.warn("Can't share document of activity {} to space of activity {}, because param {} is empty", new Object[]{originalActivityId, sharedActivityId, WORKSPACE});
                return;
            }
            String[] originalActivityFilesIds = this.getParameterValues(originalActivityTemplateParams, ID);
            if (originalActivityFilesIds == null || originalActivityFilesIds.length == 0) {
                LOG.warn("Can't share document of activity {} to space of activity {}, because param {} is empty", new Object[]{originalActivityId, sharedActivityId, ID});
                return;
            }
            HashMap<String, String> templateParams = new HashMap<String, String>();
            this.concatenateParam(templateParams, "originalActivityId", originalActivityId);
            if (originalActivityFilesIds != null && originalActivityFilesIds.length > 0) {
                for (int i = 0; i < originalActivityFilesIds.length; ++i) {
                    String nodeTitle;
                    Node contentNode;
                    String state;
                    String originalActivityFileWorkspace = WORKSPACE_NAME;
                    if (originalActivityFilesWorkspaces != null && originalActivityFilesWorkspaces.length == originalActivityFilesIds.length && StringUtils.isNotBlank((CharSequence)originalActivityFilesWorkspaces[i])) {
                        originalActivityFileWorkspace = originalActivityFilesWorkspaces[i];
                    }
                    ExtendedSession originalActivityFileNodeSession = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(originalActivityFileWorkspace, this.repoService.getCurrentRepository());
                    Node originalActivityFileNode = originalActivityFileNodeSession.getNodeByIdentifier(originalActivityFilesIds[i]);
                    String targetSpaceFileNodeUUID = this.publishDocumentToSpace(targetSpace.getGroupId(), originalActivityFileNode, "", "read", false);
                    Node targetSpaceFileNode = originalActivityFileNode.getSession().getNodeByUUID(targetSpaceFileNodeUUID);
                    this.concatenateParam(templateParams, "Shared_id", targetSpaceFileNodeUUID);
                    String repository = ((ManageableRepository)targetSpaceFileNode.getSession().getRepository()).getConfiguration().getName();
                    this.concatenateParam(templateParams, "Shared_REPOSITORY", repository);
                    String workspace = targetSpaceFileNode.getSession().getWorkspace().getName();
                    this.concatenateParam(templateParams, "Shared_WORKSPACE", workspace);
                    this.concatenateParam(templateParams, "Shared_contenLink", org.exoplatform.wcm.ext.component.activity.listener.Utils.getContentLink(targetSpaceFileNode));
                    try {
                        state = targetSpaceFileNode.hasProperty("publication:currentState") ? targetSpaceFileNode.getProperty("publication:currentState").getValue().getString() : "";
                    }
                    catch (Exception e) {
                        state = "";
                    }
                    this.concatenateParam(templateParams, "Shared_state", state);
                    SimpleDateFormat dateFormatter = null;
                    dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    String strDateCreated = "";
                    if (targetSpaceFileNode.hasProperty("exo:dateCreated")) {
                        Calendar dateCreated = targetSpaceFileNode.getProperty("exo:dateCreated").getDate();
                        strDateCreated = dateFormatter.format(dateCreated.getTime());
                        this.concatenateParam(templateParams, "Shared_dateCreated", strDateCreated);
                    }
                    String strLastModified = "";
                    if (targetSpaceFileNode.hasNode("jcr:content") && (contentNode = targetSpaceFileNode.getNode("jcr:content")).hasProperty("jcr:lastModified")) {
                        Calendar lastModified = contentNode.getProperty("jcr:lastModified").getDate();
                        strLastModified = dateFormatter.format(lastModified.getTime());
                        this.concatenateParam(templateParams, "Shared_lastModified", strLastModified);
                    }
                    this.concatenateParam(templateParams, "Shared_mimeType", org.exoplatform.wcm.ext.component.activity.listener.Utils.getMimeType(originalActivityFileNode));
                    this.concatenateParam(templateParams, "Shared_imagePath", org.exoplatform.wcm.ext.component.activity.listener.Utils.getIllustrativeImage(targetSpaceFileNode));
                    try {
                        nodeTitle = Utils.getTitle((Node)targetSpaceFileNode);
                    }
                    catch (Exception e1) {
                        nodeTitle = "";
                    }
                    this.concatenateParam(templateParams, "Shared_docTitle", nodeTitle);
                    this.concatenateParam(templateParams, "Shared_docVersion", "");
                    this.concatenateParam(templateParams, "Shared_docSummary", org.exoplatform.wcm.ext.component.activity.listener.Utils.getFirstSummaryLines(org.exoplatform.wcm.ext.component.activity.listener.Utils.getSummary(targetSpaceFileNode), org.exoplatform.wcm.ext.component.activity.listener.Utils.MAX_SUMMARY_CHAR_COUNT));
                    this.concatenateParam(templateParams, "Shared_DOCPATH", targetSpaceFileNode.getPath());
                    this.concatenateParam(templateParams, "Shared_link", "");
                    this.concatenateParam(templateParams, "Shared_isSymlink", "true");
                    this.concatenateParam(templateParams, "Shared_originalFileSize", this.getSize(originalActivityFileNode));
                    this.concatenateParam(templateParams, "Shared_originalFileDownloadUrl", Utils.getDownloadRestServiceLink((Node)originalActivityFileNode));
                }
            }
            sharedActivity.setTemplateParams(templateParams);
            this.activityManager.updateActivity(sharedActivity);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    private void removeSpacePermission(ExtendedNode node, String space) {
        block2: {
            try {
                node.removePermission("*:" + space);
                node.save();
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeUserPermission(ExtendedNode node, String user) {
        block2: {
            try {
                node.removePermission(user);
                node.save();
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getMimeType(Node node) {
        block3: {
            try {
                if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                    return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    private void setSpacePermission(Node currentNode, String memberShip, String[] permissions) throws Exception {
        ExtendedNode node = (ExtendedNode)currentNode;
        if (node.getACL().getPermissions("*:" + memberShip) == null || node.getACL().getPermissions("*:" + memberShip).size() == 0) {
            if (node.canAddMixin(MIX_PRIVILEGEABLE)) {
                node.addMixin(MIX_PRIVILEGEABLE);
            }
            node.setPermission("*:" + memberShip, permissions);
            node.save();
        }
    }

    private void setUserPermission(Node currentNode, String username, String[] permissions) throws Exception {
        ExtendedNode node = (ExtendedNode)currentNode;
        if (node.canAddMixin(MIX_PRIVILEGEABLE)) {
            node.addMixin(MIX_PRIVILEGEABLE);
        }
        node.setPermission(username, permissions);
        node.save();
    }

    private String[] getParameterValues(Map<String, String> activityParams, String paramName) {
        String[] values = null;
        String value = activityParams.get(paramName);
        if (value == null) {
            value = activityParams.get(paramName.toLowerCase());
        }
        if (value != null) {
            values = value.split("\\|@\\|");
        }
        return values;
    }

    private void concatenateParam(Map<String, String> activityParams, String paramName, String paramValue) {
        String oldParamValue = activityParams.get(paramName);
        if (StringUtils.isBlank((CharSequence)oldParamValue)) {
            activityParams.put(paramName, paramValue);
        } else {
            activityParams.put(paramName, oldParamValue + TEMPLATE_PARAMS_SEPARATOR + paramValue);
        }
    }

    private String getSize(Node node) {
        double size = 0.0;
        try {
            if (node.hasNode("jcr:content")) {
                Node contentNode = node.getNode("jcr:content");
                if (contentNode.hasProperty("jcr:data")) {
                    size = contentNode.getProperty("jcr:data").getLength();
                }
                return FileUtils.byteCountToDisplaySize((long)((long)size));
            }
        }
        catch (PathNotFoundException e) {
            return "";
        }
        catch (ValueFormatException e) {
            return "";
        }
        catch (RepositoryException e) {
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
        return "";
    }
}

