/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ViewConfig {
    private String name;
    private String permissions;
    private String template;
    private boolean hideExplorerPanel = false;
    private List<Tab> tabList = new ArrayList<Tab>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permission) {
        this.permissions = permission;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String templ) {
        this.template = templ;
    }

    public List<Tab> getTabList() {
        return this.tabList;
    }

    public void setTabList(List<Tab> tabs) {
        this.tabList = tabs;
    }

    public boolean isHideExplorerPanel() {
        return this.hideExplorerPanel;
    }

    public void setHideExplorerPanel(boolean value) {
        this.hideExplorerPanel = value;
    }

    public List<String> getAllPermissions() {
        String[] allPermissions = StringUtils.split((String)this.permissions, (String)";");
        ArrayList<String> permissionList = new ArrayList<String>();
        for (int i = 0; i < allPermissions.length; ++i) {
            permissionList.add(allPermissions[i].trim());
        }
        return permissionList;
    }

    public boolean hasPermission(String permission) {
        List<String> allPermissions = this.getAllPermissions();
        if (permission == null) {
            return false;
        }
        String[] array = StringUtils.split((String)permission, (String)":/");
        if (array == null || array.length < 2) {
            return false;
        }
        int i = allPermissions.indexOf("*:/" + array[1]);
        if (i > -1) {
            return true;
        }
        return allPermissions.contains(permission);
    }

    public static class Tab {
        private String tabName;
        private String buttons;
        private String localizeButtons;

        public String getTabName() {
            return this.tabName;
        }

        public void setTabName(String name) {
            this.tabName = name;
        }

        public String getButtons() {
            return this.buttons;
        }

        public void setButtons(String buttons) {
            this.buttons = buttons;
        }

        public String getLocalizeButtons() {
            return this.localizeButtons;
        }

        public void setLocalizeButtons(String buttons) {
            this.localizeButtons = buttons;
        }
    }
}

