/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents;

import java.util.LinkedHashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.documents.DocumentEditorProvider;
import org.exoplatform.services.cms.documents.NewDocumentTemplate;
import org.exoplatform.services.cms.documents.NewDocumentTemplateConfig;
import org.exoplatform.services.cms.documents.NewDocumentTemplateProvider;
import org.exoplatform.services.cms.documents.exception.DocumentEditorProviderNotFoundException;
import org.exoplatform.services.cms.documents.model.Document;
import org.exoplatform.services.cms.drives.DriveData;

public interface DocumentService {
    public Document findDocById(String var1) throws RepositoryException;

    public String getShortLinkInDocumentsApp(String var1, String var2) throws Exception;

    default public String getDocumentUrlInPersonalDocuments(Node currentNode, String username) throws Exception {
        return null;
    }

    default public String getDocumentUrlInSpaceDocuments(Node currentNode, String spaceId) throws Exception {
        return null;
    }

    public String getLinkInDocumentsApp(String var1) throws Exception;

    default public String getLinkInDocumentsAppByIdentifier(String nodeIdentifier) throws Exception {
        throw new UnsupportedOperationException("This is the default function, it should not be used !");
    }

    public String getLinkInDocumentsApp(String var1, DriveData var2) throws Exception;

    default public String getLinkInDocumentsAppByIdentifier(String nodeIdentifier, DriveData drive) throws Exception {
        throw new UnsupportedOperationException("This is the default function, it should not be used !");
    }

    default public DriveData getDriveOfNode(String nodePath) throws Exception {
        throw new UnsupportedOperationException("This is the default function, it should not be used !");
    }

    default public DriveData getDriveOfNodeByIdentifier(String nodeIdentifier) throws Exception {
        throw new UnsupportedOperationException("This is the default function, it should not be used !");
    }

    public DriveData getDriveOfNode(String var1, String var2, List<String> var3) throws Exception;

    default public LinkedHashMap<String, String> getFilePreviewBreadCrumb(Node fileNode) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void addDocumentTemplatePlugin(ComponentPlugin var1);

    public void addDocumentEditorPlugin(ComponentPlugin var1);

    public Node createDocumentFromTemplate(Node var1, String var2, NewDocumentTemplate var3) throws Exception;

    public List<NewDocumentTemplateProvider> getNewDocumentTemplateProviders();

    public void addDocumentMetadataPlugin(ComponentPlugin var1);

    public String getPreferredEditor(String var1, String var2, String var3) throws RepositoryException;

    public void savePreferredEditor(String var1, String var2, String var3, String var4) throws RepositoryException;

    public List<DocumentEditorProvider> getDocumentEditorProviders();

    public void saveCurrentDocumentProvider(String var1, String var2, String var3) throws RepositoryException;

    public String getCurrentDocumentProvider(String var1, String var2) throws RepositoryException;

    public DocumentEditorProvider getEditorProvider(String var1) throws DocumentEditorProviderNotFoundException;

    public void setCommonEditorPlugin(ComponentPlugin var1);

    public long getEditorsIdleTimeout();

    default public List<Document> getDocumentsByFolder(String folder, String condition, long limit) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public List<Document> getDocumentsByQuery(String query, long limit) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public List<Document> getFavoriteDocuments(String userId, int limit) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public List<Document> getSharedDocuments(String userId, int limit) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public List<Document> getRecentSpacesDocuments(int limit) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static class DocumentTemplatesConfig {
        protected List<NewDocumentTemplateConfig> templates;
        protected String providerName;

        public List<NewDocumentTemplateConfig> getTemplates() {
            return this.templates;
        }

        public void setTemplates(List<NewDocumentTemplateConfig> templates) {
            this.templates = templates;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public void setProviderName(String providerName) {
            this.providerName = providerName;
        }
    }
}

