/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.templates.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class TemplatePlugin
extends BaseComponentPlugin {
    public static final String DIALOGS = "dialogs";
    public static final String VIEWS = "views";
    public static final String SKINS = "skins";
    public static final String DEFAULT_DIALOG = "dialog1";
    public static final String DEFAULT_VIEW = "view1";
    static final String[] UNDELETABLE_TEMPLATES = new String[]{"dialog1", "view1"};
    public static final String DEFAULT_DIALOGS_PATH = "/dialogs/dialog1";
    public static final String DEFAULT_VIEWS_PATH = "/views/view1";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String DOCUMENT_TEMPLATE_PROP = "isDocumentTemplate";
    public static final String TEMPLATE_LABEL = "label";
    public static final String[] EXO_ROLES_DEFAULT = new String[]{"*"};
    private static final String NAME;
    private static final String COMMENT_TEMPLATE;
    private static final String HEADER_VIEW;
    private static final String JAVA_HEADER_VIEW;
    private static final String DEF_FIELD_PROPERTY;
    private static final String FIELD_PROPERTY;
    private static final String START_DIALOG_FORM;
    private static final String END_DIALOG_FORM;
    private static final String TD_LABEL;
    private static final String TD_COMPONENT;
    private static final String START_TABLE;
    private static final String END_TABLE;
    private static final String START_TR;
    private static final String END_TR;
    private static final String CHECK_PROPERTY;
    private static final String GET_PROPERTY;
    private static final String START_JAVA;
    private static final String END_JAVA;
    private static final String DEFAULT_CSS;
    private static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    private static final String JCR_MIXIN_TYPES = "jcr:mixinTypes";
    private RepositoryService repositoryService_;
    private ConfigurationManager configManager_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String cmsTemplatesBasePath_;
    private InitParams params_;
    private String storedLocation_;
    private boolean autoCreateInNewRepository_ = false;
    private static final Log LOG;
    private Set<String> configuredNodeTypes;
    private TemplateService templateService;
    private DMSConfiguration dmsConfiguration_;

    public TemplatePlugin(InitParams params, RepositoryService jcrService, ConfigurationManager configManager, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = jcrService;
        this.configManager_ = configManager;
        this.cmsTemplatesBasePath_ = this.nodeHierarchyCreator_.getJcrPath("templatesPath");
        this.params_ = params;
        ValueParam locationParam = this.params_.getValueParam("storedLocation");
        this.storedLocation_ = locationParam.getValue();
        ValueParam param = this.params_.getValueParam("autoCreateInNewRepository");
        if (param != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(param.getValue());
        }
        this.dmsConfiguration_ = dmsConfiguration;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    public void init() throws Exception {
        this.configuredNodeTypes = new HashSet<String>();
        this.importPredefineTemplates();
    }

    private void addTemplate(TemplateConfig templateConfig, Node templatesHome, String storedLocation) throws Exception {
        Set<String> editedPredefinedNodeTypes = this.templateService.getAllEditedConfiguredNodeTypes();
        NodeTypeManager ntManager = templatesHome.getSession().getWorkspace().getNodeTypeManager();
        NodeTypeIterator nodetypeIter = ntManager.getAllNodeTypes();
        ArrayList<String> listNodeTypeName = new ArrayList<String>();
        while (nodetypeIter.hasNext()) {
            NodeType n1 = nodetypeIter.nextNodeType();
            listNodeTypeName.add(n1.getName());
        }
        List<TemplateConfig.NodeType> nodetypes = templateConfig.getNodeTypes();
        TemplateConfig.NodeType nodeType2 = null;
        for (TemplateConfig.NodeType nodeType2 : nodetypes) {
            if (Utils.getAllEditedConfiguredData("ContentTemplateList", "EditedConfiguredTemplateList", true).contains(nodeType2.getNodetypeName()) || !listNodeTypeName.contains(nodeType2.getNodetypeName())) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("The nodetype: " + nodeType2.getNodetypeName() + " or its templates doesn't exist!"));
                continue;
            }
            this.configuredNodeTypes.add(nodeType2.getNodetypeName());
            if (editedPredefinedNodeTypes.contains(nodeType2.getNodetypeName())) continue;
            Node nodeTypeHome = null;
            nodeTypeHome = Utils.makePath(templatesHome, nodeType2.getNodetypeName(), NT_UNSTRUCTURED);
            if (nodeType2.getDocumentTemplate()) {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, true);
            } else {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, false);
            }
            nodeTypeHome.setProperty(TEMPLATE_LABEL, nodeType2.getLabel());
            List dialogs = nodeType2.getReferencedDialog();
            this.addNode(storedLocation, nodeType2, dialogs, DIALOGS, templatesHome);
            List views = nodeType2.getReferencedView();
            this.addNode(storedLocation, nodeType2, views, VIEWS, templatesHome);
            List skins = nodeType2.getReferencedSkin();
            if (skins == null) continue;
            this.addNode(storedLocation, nodeType2, skins, SKINS, templatesHome);
        }
    }

    public void setBasePath(String basePath) {
        this.cmsTemplatesBasePath_ = basePath;
    }

    private void importPredefineTemplates() throws Exception {
        Object object;
        ManageableRepository repository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        String workspace = dmsRepoConfig.getSystemWorkspace();
        Session session = repository.getSystemSession(workspace);
        Node templatesHome = Utils.makePath(session.getRootNode(), this.cmsTemplatesBasePath_, NT_UNSTRUCTURED);
        TemplateConfig templateConfig = null;
        Iterator iter = this.params_.getObjectParamIterator();
        while (iter.hasNext() && (object = ((ObjectParameter)iter.next()).getObject()) instanceof TemplateConfig) {
            templateConfig = (TemplateConfig)object;
            this.addTemplate(templateConfig, templatesHome, this.storedLocation_);
        }
        session.logout();
    }

    private void addNode(String basePath, TemplateConfig.NodeType nodeType, List templates, String templateType, Node templatesHome) throws Exception {
        for (TemplateConfig.Template template : templates) {
            String templateFileName = template.getTemplateFile();
            String path = basePath + templateFileName;
            InputStream in = this.configManager_.getInputStream(path);
            String nodeName = templateFileName.substring(templateFileName.lastIndexOf("/") + 1, templateFileName.indexOf("."));
            Node nodeTypeHome = null;
            nodeTypeHome = !templatesHome.hasNode(nodeType.getNodetypeName()) ? Utils.makePath(templatesHome, nodeType.getNodetypeName(), NT_UNSTRUCTURED) : templatesHome.getNode(nodeType.getNodetypeName());
            Node specifiedTemplatesHome = null;
            try {
                specifiedTemplatesHome = nodeTypeHome.getNode(templateType);
            }
            catch (PathNotFoundException e) {
                specifiedTemplatesHome = Utils.makePath(nodeTypeHome, templateType, NT_UNSTRUCTURED);
            }
            if (specifiedTemplatesHome.hasNode(nodeName)) continue;
            this.templateService.addTemplate(templateType, nodeType.getNodetypeName(), nodeType.getLabel(), nodeType.getDocumentTemplate(), nodeName, template.getParsedRoles(), in, templatesHome);
        }
    }

    public String buildStyleSheet(NodeType nodeType) {
        return COMMENT_TEMPLATE.concat(DEFAULT_CSS);
    }

    public String buildDialogForm(NodeType nodeType) throws ValueFormatException, RepositoryException {
        StringBuilder buildDialogForm = new StringBuilder(COMMENT_TEMPLATE);
        buildDialogForm.append(START_DIALOG_FORM).append(START_TABLE);
        buildDialogForm.append(START_TR);
        buildDialogForm.append(DEF_FIELD_PROPERTY);
        buildDialogForm.append(TD_LABEL.replace("${nodetypename}", nodeType.getName()).replace(":", "_").replace("${propertyname}", "name"));
        buildDialogForm.append(TD_COMPONENT.replace("${contentcomponent}", NAME));
        buildDialogForm.append(END_TR);
        buildDialogForm.append(this.buildDialogNodeType(nodeType));
        buildDialogForm.append(END_TABLE);
        buildDialogForm.append(END_DIALOG_FORM);
        return buildDialogForm.toString();
    }

    private String buildDialogNodeType(NodeType nodeType) throws ValueFormatException, RepositoryException {
        return this.buildDialogNodeType(nodeType, "/node/");
    }

    private String buildDialogNodeType(NodeType nodeType, String jcrPath) throws ValueFormatException, RepositoryException {
        NodeDefinition[] childdefs;
        PropertyDefinition[] prodefs;
        StringBuilder buildDialogNodeType = new StringBuilder();
        for (PropertyDefinition prodef : prodefs = nodeType.getPropertyDefinitions()) {
            String propertyName = prodef.getName();
            if (prodef.isAutoCreated() || "*".equals(propertyName) || JCR_PRIMARY_TYPE.equals(propertyName) || JCR_MIXIN_TYPES.equals(propertyName)) continue;
            String propertyNameFormat = propertyName.replace(":", "_");
            String propertyPath = jcrPath.concat(propertyName);
            String propertyId = propertyPath.replace(":", "_");
            StringBuilder componentField = new StringBuilder("\n\t\t\t\t\t\tuicomponent.addTextField(\"").append(propertyId).append("\", ");
            StringBuilder validate = new StringBuilder("validate=");
            buildDialogNodeType.append(START_TR);
            buildDialogNodeType.append(TD_LABEL.replace("${nodetypename}", nodeType.getName()).replace(":", "_").replace("${propertyname}", propertyNameFormat));
            StringBuilder params = new StringBuilder("\t\t\t\t\t\t").append(FIELD_PROPERTY).append(" = [\"jcrPath=").append(propertyPath).append("\"");
            if (prodef.isMultiple()) {
                params.append(", \"multiValues=true\"");
            }
            if (prodef.isMandatory()) {
                validate.append("empty,");
            }
            switch (prodef.getRequiredType()) {
                case 6: {
                    params.append(", \"options=true,false\"");
                    componentField = new StringBuilder("\n\t\t\t\t\t\tuicomponent.addSelectBoxField(\"").append(propertyId).append("\", ");
                    break;
                }
                case 1: {
                    break;
                }
                case 5: {
                    validate.append("datetime,");
                    params.append(", \"options=displaytime\", \"visible=true\"");
                    componentField = new StringBuilder("\n\t\t\t\t\t\tuicomponent.addCalendarField(\"").append(propertyId).append("\", ");
                    break;
                }
                case 3: {
                    validate.append("number,");
                    break;
                }
                case 4: {
                    validate.append("number,");
                    break;
                }
                case 9: {
                    params.append(", \"reference=true\", \"editable=false\"");
                    break;
                }
                case 2: {
                    componentField = new StringBuilder("\n\t\t\t\t\t\tuicomponent.addUploadField(\"").append(propertyId).append("\", ");
                    break;
                }
            }
            Value[] defaultValuesArr = prodef.getDefaultValues();
            if (defaultValuesArr != null) {
                StringBuilder defaultValues = new StringBuilder("defaultValues=");
                for (NodeType nodeType2 : defaultValuesArr) {
                    defaultValues.append(nodeType2.getString()).append(",");
                }
                if (defaultValues.indexOf(",") > -1) {
                    params.append(", \"").append((CharSequence)defaultValues.deleteCharAt(defaultValues.length() - 1)).append("\"");
                }
            }
            if (validate.indexOf(",") > -1) {
                params.append(", \"").append((CharSequence)validate.deleteCharAt(validate.length() - 1)).append("\"");
            }
            params.append("];");
            componentField.append(FIELD_PROPERTY).append(");");
            buildDialogNodeType.append(TD_COMPONENT.replace("${contentcomponent}", START_JAVA.concat(params.append((CharSequence)componentField).append(END_JAVA).append("\n").toString())));
            buildDialogNodeType.append(END_TR);
        }
        for (NodeDefinition childdef : childdefs = nodeType.getChildNodeDefinitions()) {
            if (childdef == null) continue;
            for (NodeType nodeType3 : childdef.getRequiredPrimaryTypes()) {
                jcrPath = childdef.getName().equals("*") ? jcrPath.concat(childdef.getRequiredPrimaryTypes()[0].getName()).concat("/") : jcrPath.concat(childdef.getName()).concat("/");
                buildDialogNodeType.append(this.buildDialogNodeType(nodeType3, jcrPath));
            }
        }
        return buildDialogNodeType.toString();
    }

    public String buildViewForm(NodeType nodeType) {
        StringBuilder buildViewForm = new StringBuilder(COMMENT_TEMPLATE);
        buildViewForm.append(HEADER_VIEW.replace("${NodeType}", nodeType.getName()));
        buildViewForm.append(JAVA_HEADER_VIEW);
        buildViewForm.append("\n\t\t<div id=\"$uicomponent.id\">");
        buildViewForm.append(START_TABLE);
        buildViewForm.append(START_TR);
        buildViewForm.append(TD_LABEL.replace("${nodetypename}", nodeType.getName()).replace(":", "_").replace("${propertyname}", "name"));
        buildViewForm.append(TD_COMPONENT.replace("${contentcomponent}\t\t\t\t\t", "${name}"));
        buildViewForm.append(END_TR);
        buildViewForm.append(this.buildViewNodeType(nodeType));
        buildViewForm.append(END_TABLE);
        buildViewForm.append("\t\t</div>");
        return buildViewForm.toString();
    }

    private String buildViewNodeType(NodeType nodeType) {
        PropertyDefinition[] prodefs;
        StringBuilder buildViewNodeType = new StringBuilder();
        String label = TD_LABEL.replace("${nodetypename}", nodeType.getName().replace(":", "_"));
        for (PropertyDefinition prodef : prodefs = nodeType.getPropertyDefinitions()) {
            buildViewNodeType.append(START_JAVA).append(CHECK_PROPERTY.replace("${propertyname}", prodef.getName())).append(END_JAVA);
            buildViewNodeType.append(START_TR);
            buildViewNodeType.append(label.replace("${propertyname}", prodef.getName().replace(":", "_")));
            buildViewNodeType.append(START_JAVA);
            if (prodef.getRequiredType() == 2) {
                if (prodef.isMultiple()) {
                    buildViewNodeType.append("\t\t\t\t\t// Render for multi value;\n");
                    buildViewNodeType.append("\t\t\t\t\tvalues = ").append(GET_PROPERTY.replace("${propertyname}", prodef.getName())).append(".getValues()").append(";\n");
                    buildViewNodeType.append("\t\t\t\t\tvalueDisplay = \"\";\n");
                    buildViewNodeType.append("\t\t\t\t\tfor(value in values) {\n");
                    buildViewNodeType.append("\t\t\t\t\t\tvalueDisplay += \"BINARY DATA\" + \",\";\n");
                    buildViewNodeType.append("\t\t\t\t\t}\n");
                    buildViewNodeType.append("\t\t\t\t\tif (valueDisplay.length() > 0 && valueDisplay.indexOf(\",\") > -1) valueDisplay = valueDisplay.substring(0, valueDisplay.length() - 1);");
                } else {
                    buildViewNodeType.append("\t\t\t\t\t// Render for single value;\n");
                    buildViewNodeType.append("\t\t\t\t\tvalueDisplay = \"BINARY DATA\"");
                }
            } else if (prodef.isMultiple()) {
                buildViewNodeType.append("\t\t\t\t\t// Render for multi value;\n");
                buildViewNodeType.append("\t\t\t\t\tvalues = ").append(GET_PROPERTY.replace("${propertyname}", prodef.getName())).append(".getValues()").append(";\n");
                buildViewNodeType.append("\t\t\t\t\tvalueDisplay = \"\";\n");
                buildViewNodeType.append("\t\t\t\t\tfor(value in values) {\n");
                buildViewNodeType.append("\t\t\t\t\t\tvalueDisplay += value.getString() + \",\";\n");
                buildViewNodeType.append("\t\t\t\t\t}\n");
                buildViewNodeType.append("\t\t\t\t\tif (valueDisplay.length() > 0 && valueDisplay.indexOf(\",\") > -1) valueDisplay = valueDisplay.substring(0, valueDisplay.length() - 1);");
            } else {
                buildViewNodeType.append("\t\t\t\t\t// Render for single value;\n");
                buildViewNodeType.append("\t\t\t\t\tvalueDisplay = ").append(GET_PROPERTY.replace("${propertyname}", prodef.getName())).append(".getString();");
            }
            buildViewNodeType.append(END_JAVA);
            buildViewNodeType.append(TD_COMPONENT.replace("${contentcomponent}\t\t\t\t\t", "${valueDisplay}"));
            buildViewNodeType.append(END_TR);
            buildViewNodeType.append(START_JAVA).append("\t\t\t\t\t}").append(END_JAVA);
        }
        return buildViewNodeType.toString();
    }

    public Set<String> getAllConfiguredNodeTypes() {
        return this.configuredNodeTypes;
    }

    static {
        LOG = ExoLogger.getLogger((String)TemplatePlugin.class.getName());
        COMMENT_TEMPLATE = "<%\n// Generate template for nodetype automatically\n%>\n";
        HEADER_VIEW = "<style>\n" + "\t<% _ctx.include(uicomponent.getTemplateSkin(\"${NodeType}\", \"Stylesheet\")); %>\n" + "</style>\n";
        JAVA_HEADER_VIEW = "<%\n\tdef node = uicomponent.getNode();\n" + "\tdef name = node.getName();\n" + "\tdef values;\n" + "\tdef valueDisplay;\n%>";
        DEF_FIELD_PROPERTY = "\t\t\t\t\t<%\n\t\t\t\t\t\tString[] fieldProperty; \n\t\t\t\t\t%>\n";
        FIELD_PROPERTY = "fieldProperty";
        START_DIALOG_FORM = "<div class=\"UIForm FormLayout FormScrollLayout\">\n" + "\t<% uiform.begin();\n" + "\t   /* start render action*/\n" + "\t   if (uiform.isShowActionsOnTop()) uiform.processRenderAction();\n" + "\t   /* end render action*/\n" + "\t%> \n" + "\t\t<div class=\"HorizontalLayout\">\n";
        NAME = "\n\t\t\t\t\t<%\n" + "\t\t\t\t\t\tString[] fieldName = [\"jcrPath=/node\", \"editable=if-null\", \"validate=empty,name\"];\n" + "\t\t\t\t\t\tuicomponent.addTextField(\"name\", fieldName);\n" + "\t\t\t\t\t%>\n";
        START_TABLE = "\n\t\t\t<table class=\"UIFormGrid\">\n";
        START_TR = "\n\t\t\t\t<tr>\n";
        END_TR = "\t\t\t\t</tr>";
        START_JAVA = "\n\t\t\t\t<%\n";
        END_JAVA = "\n\t\t\t\t%>";
        CHECK_PROPERTY = "\t\t\t\t if (node.hasProperty(\"${propertyname}\")) {";
        GET_PROPERTY = "node.getProperty(\"${propertyname}\")";
        TD_LABEL = "" + "\t\t\t\t\t<td class=\"FieldLabel\">" + "<%=_ctx.appRes(\"${nodetypename}.dialog.label.${propertyname}\")%>" + "</td>";
        TD_COMPONENT = "\n" + "\t\t\t\t\t<td class=\"FieldComponent\">" + "${contentcomponent}" + "\t\t\t\t\t</td>\n";
        END_TABLE = "\n\t\t\t</table>\n";
        END_DIALOG_FORM = "" + "\t\t</div>\n" + "\t<% /* start render action*/\n" + "\t   if (!uiform.isShowActionsOnTop()) uiform.processRenderAction();\n" + "\t   /* end render action*/\n" + "\t   uiform.end();\n\t%>\n" + "</div>";
        DEFAULT_CSS = ".UIFormGrid {" + "\n\tborder:1px solid #B7B7B7;" + "\n\tborder-collapse:collapse;" + "\n\tmargin:auto;" + "\n\tpadding-left:1px;" + "\n\ttable-layout:fixed;" + "\n}" + "\n\n.UIFormGrid .FieldLabel {" + "\n\tfont-weight:bold;" + "\n\twidth:auto;" + "\n}" + "\n\n.UIFormGrid td {" + "\n\tborder-left:1px solid #CCCCCC;" + "\n\tborder-right:1px solid #CCCCCC;" + "\n\tborder-top:1px solid #FFFFFF;" + "\n\tbackground:#F3F3F3 none repeat scroll 0 0;" + "\n\theight:20px;" + "\n\tline-height:20px;" + "\n\tpadding:4px;" + "\n}";
    }
}

