/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.comments.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class CommentsServiceImpl
implements CommentsService {
    private static final Log LOG = ExoLogger.getLogger((String)CommentsServiceImpl.class.getName());
    private static final String CACHE_NAME = "ecms.CommentsService";
    private static final String COMMENTS = "comments";
    private static final String COMMENTABLE = "mix:commentable";
    private static final String EXO_COMMENTS = "exo:comments";
    private static final String NT_UNSTRUCTURE = "nt:unstructured";
    private static final String MESSAGE = "exo:commentContent";
    private static final String COMMENTOR = "exo:commentor";
    private static final String COMMENTOR_FULLNAME = "exo:commentorFullName";
    private static final String COMMENTOR_EMAIL = "exo:commentorEmail";
    private static final String COMMENTOR_SITE = "exo:commentorSite";
    private static final String CREATED_DATE = "exo:commentDate";
    private static final String LANGUAGES = "languages";
    private static final String ANONYMOUS = "anonymous";
    private ExoCache<String, List<Node>> commentsCache_;
    private MultiLanguageService multiLangService_;
    private ListenerService listenerService_;
    private ActivityCommonService activityService;

    public CommentsServiceImpl(CacheService cacheService, MultiLanguageService multiLangService, ListenerService listenerService) throws Exception {
        this.commentsCache_ = cacheService.getCacheInstance(CACHE_NAME);
        this.multiLangService_ = multiLangService;
        this.listenerService_ = listenerService;
        this.activityService = WCMCoreUtils.getService(ActivityCommonService.class);
    }

    @Override
    public void addComment(Node node, String commentor, String email, String site, String comment, String language) throws Exception {
        block22: {
            Session session = node.getSession();
            try {
                Node commentNode;
                block21: {
                    Node document = (Node)session.getItem(node.getPath());
                    if (!document.isNodeType(COMMENTABLE)) {
                        if (document.canAddMixin(COMMENTABLE)) {
                            document.addMixin(COMMENTABLE);
                        } else {
                            throw new Exception("This node does not support comments.");
                        }
                    }
                    Node multiLanguages = null;
                    Node languageNode = null;
                    commentNode = null;
                    if (!document.hasNode(LANGUAGES) || language.equals(this.multiLangService_.getDefault(document))) {
                        if (document.hasNode(COMMENTS)) {
                            commentNode = document.getNode(COMMENTS);
                        } else {
                            commentNode = document.addNode(COMMENTS, NT_UNSTRUCTURE);
                            commentNode.addMixin("exo:hiddenable");
                        }
                    } else {
                        multiLanguages = document.getNode(LANGUAGES);
                        languageNode = multiLanguages.hasNode(language) ? multiLanguages.getNode(language) : multiLanguages.addNode(language);
                        if (languageNode.hasNode(COMMENTS)) {
                            commentNode = languageNode.getNode(COMMENTS);
                        } else {
                            commentNode = languageNode.addNode(COMMENTS, NT_UNSTRUCTURE);
                            commentNode.addMixin("exo:hiddenable");
                        }
                    }
                    if (commentor == null || commentor.length() == 0) {
                        commentor = ANONYMOUS;
                    }
                    GregorianCalendar commentDate = new GregorianCalendar();
                    String name = Long.toString(commentDate.getTimeInMillis());
                    Node newComment = commentNode.addNode(name, EXO_COMMENTS);
                    newComment.setProperty(COMMENTOR, commentor);
                    OrganizationService organizationService = WCMCoreUtils.getService(OrganizationService.class);
                    User user = organizationService.getUserHandler().findUserByName(commentor);
                    if (user == null) {
                        newComment.setProperty(COMMENTOR_FULLNAME, "ANONYMOUS");
                    } else {
                        String fullName = user.getDisplayName();
                        if (fullName == null) {
                            fullName = user.getUserName();
                        }
                        newComment.setProperty(COMMENTOR_FULLNAME, fullName);
                    }
                    newComment.setProperty(CREATED_DATE, (Calendar)commentDate);
                    newComment.setProperty(MESSAGE, comment);
                    if (email != null && email.length() > 0) {
                        newComment.setProperty(COMMENTOR_EMAIL, email);
                    }
                    if (site != null && site.length() > 0) {
                        newComment.setProperty(COMMENTOR_SITE, site);
                    }
                    document.save();
                    if (this.listenerService_ != null) {
                        try {
                            if (this.activityService.isAcceptedNode(document) || document.getPrimaryNodeType().getName().equals("nt:file") && this.activityService.isBroadcastNTFileEvents(document)) {
                                this.listenerService_.broadcast(ActivityCommonService.COMMENT_ADDED_ACTIVITY, (Object)document, (Object)newComment);
                            }
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) break block21;
                            LOG.error((Object)("Can not notify CommentAddedActivity because of: " + e.getMessage()));
                        }
                    }
                }
                this.commentsCache_.remove((Serializable)((Object)commentNode.getPath()));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block22;
                LOG.error((Object)"Unexpected problem happen when try to add comment", (Throwable)e);
            }
        }
    }

    @Override
    public void updateComment(Node commentNode, String newComment) throws Exception {
        block4: {
            GregorianCalendar commentDate = new GregorianCalendar();
            commentNode.setProperty(CREATED_DATE, (Calendar)commentDate);
            commentNode.setProperty(MESSAGE, newComment);
            commentNode.save();
            Node documentNode = commentNode.getParent().getParent();
            if (this.listenerService_ != null && this.activityService != null) {
                try {
                    if (this.activityService.isAcceptedNode(documentNode) || documentNode.getPrimaryNodeType().getName().equals("nt:file") && this.activityService.isBroadcastNTFileEvents(documentNode)) {
                        this.listenerService_.broadcast(ActivityCommonService.COMMENT_UPDATED_ACTIVITY, (Object)documentNode, (Object)commentNode);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)("Can not notify CommentModifiedActivity because of: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public void deleteComment(Node commentNode) throws Exception {
        block4: {
            Node document = commentNode.getParent();
            commentNode.remove();
            document.save();
            if (this.listenerService_ != null && this.activityService != null) {
                Node parentNode = document.getParent();
                try {
                    if (this.activityService.isAcceptedNode(parentNode) || parentNode.getPrimaryNodeType().getName().equals("nt:file") && this.activityService.isBroadcastNTFileEvents(parentNode)) {
                        this.listenerService_.broadcast(ActivityCommonService.COMMENT_REMOVED_ACTIVITY, (Object)commentNode, null);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)("Can not notify CommentRemovedActivity because of: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public List<Node> getComments(Node document, String language) throws Exception {
        ArrayList<Node> list;
        block12: {
            Node commentsNode = null;
            Node languagesNode = null;
            Node languageNode = null;
            if (!this.isSupportedLocalize(document, language) && document.hasProperty("exo:language")) {
                language = document.getProperty("exo:language").getString();
            }
            if (document.hasNode(LANGUAGES)) {
                languagesNode = document.getNode(LANGUAGES);
                if (languagesNode.hasNode(language)) {
                    languageNode = languagesNode.getNode(language);
                    if (languageNode.hasNode(COMMENTS)) {
                        commentsNode = languageNode.getNode(COMMENTS);
                    }
                } else if (language.equals(this.multiLangService_.getDefault(document))) {
                    languageNode = document;
                }
            } else {
                languageNode = document;
            }
            if (!languageNode.hasNode(COMMENTS)) {
                return new ArrayList<Node>();
            }
            Session session = document.getSession();
            Session systemSession = WCMCoreUtils.getSystemSessionProvider().getSession(session.getWorkspace().getName(), WCMCoreUtils.getRepository());
            list = new ArrayList<Node>();
            try {
                commentsNode = (Node)systemSession.getItem(languageNode.getPath() + "/comments");
                String cacheKey = document.getPath().concat(commentsNode.getPath());
                Object comments = this.commentsCache_.get((Serializable)((Object)cacheKey));
                if (comments != null) {
                    return (List)comments;
                }
                NodeIterator iter = commentsNode.getNodes();
                while (iter.hasNext()) {
                    list.add(iter.nextNode());
                }
                Collections.sort(list, new DateComparator(this));
                this.commentsCache_.put((Serializable)((Object)commentsNode.getPath()), list);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block12;
                LOG.error((Object)"Unexpected problem happen when try to get comments", (Throwable)e);
            }
        }
        return list;
    }

    private boolean isSupportedLocalize(Node document, String language) throws Exception {
        List<String> locales = this.multiLangService_.getSupportedLanguages(document);
        return Collections.frequency(locales, language) > 0;
    }

    private class DateComparator
    implements Comparator<Node> {
        private DateComparator(CommentsServiceImpl commentsServiceImpl) {
        }

        @Override
        public int compare(Node node1, Node node2) {
            try {
                Date date1 = node1.getProperty(CommentsServiceImpl.CREATED_DATE).getDate().getTime();
                Date date2 = node2.getProperty(CommentsServiceImpl.CREATED_DATE).getDate().getTime();
                return date2.compareTo(date1);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

