/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.listener.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.chain.Context;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class JCRNodeListener
implements Action {
    private static final String GROUPS_SPACES_PARENT_FOLDER = "/Groups/spaces/";
    private static final String DOCUMENT_NAME_PARAM = "documentName";
    private static final Log LOG = ExoLogger.getLogger(JCRNodeListener.class);
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private static final ScheduledExecutorService SCHEDULER = new ScheduledThreadPoolExecutor(0);
    private static final Executor DEFAULT_DELAYED_EXECUTOR = JCRNodeListener.delayedExecutor(3L, TimeUnit.SECONDS);
    private static final String FILE_EXTENSION_PARAM = "fileExtension";
    private static final String DOCUMENT_TYPE_PARAM = "documentType";
    private static final String UUID_PARAM = "uuid";
    private static final String FILE_SIZE_PARAM = "fileSize";
    private static final String FILE_MIME_TYPE_PARAM = "fileMimeType";
    private static final String DOCUMENT_UPDATED_OPERATION = "documentUpdated";
    private static final String FILE_UPDATED_OPERATION = "fileUpdated";
    private static final String DOCUMENT_CREATED_OPERATION = "documentCreated";
    private static final String FILE_CREATED_OPERATION = "fileCreated";
    private static final String DOCUMENT_MOVED_TO_TRASH_OPERATION = "documentMovedToTrash";
    private static final String FILE_MOVED_TO_TRASH_OPERATION = "fileMovedToTrash";
    private static final String MODULE_DOCUMENT = "Document";
    private static final String SUB_MODULE_CONTENT = "Content";
    private static final String MODULE_DRIVE = "Drive";
    private static final String SEPARATOR = "@@";
    private static final Set<String> CURRENTLY_PROCESSING_NODE_PATH_QUEUE = new HashSet<String>();
    private static final String EXO_USER_PREFERENCES = "exo:userPrefferences";
    private PortalContainer container = PortalContainer.getInstance();
    private TemplateService templateService;
    private SpaceService spaceService;
    private TrashService trashService;

    public boolean execute(Context context) throws Exception {
        try {
            Node node;
            String username = AnalyticsUtils.getUsername((ConversationState)ConversationState.getCurrent());
            boolean unkownUser = AnalyticsUtils.isUnkownUser((String)username);
            if (unkownUser) {
                return true;
            }
            Object item = context.get((Object)InvocationContext.CURRENT_ITEM);
            Node node2 = node = item instanceof Property ? ((Property)item).getParent() : (Node)item;
            if (node == null) {
                return true;
            }
            Node managedNode = this.getManagedNodeFromParents(node);
            if (managedNode == null) {
                return true;
            }
            int eventType = (Integer)context.get((Object)InvocationContext.EVENT);
            if (eventType == 1 && node.isNodeType(EXO_USER_PREFERENCES)) {
                return true;
            }
            String nodePath = managedNode.getPath();
            String queueKey = username + SEPARATOR + nodePath;
            if (CURRENTLY_PROCESSING_NODE_PATH_QUEUE.contains(queueKey)) {
                return true;
            }
            CURRENTLY_PROCESSING_NODE_PATH_QUEUE.add(queueKey);
            ManageableRepository repository = SessionProviderService.getRepository();
            String workspace = managedNode.getSession().getWorkspace().getName();
            boolean isNew = node.isNew();
            DEFAULT_DELAYED_EXECUTOR.execute(() -> {
                ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                RequestLifeCycle.begin((ExoContainer)this.container);
                SessionProvider systemProvider = SessionProvider.createSystemProvider();
                try {
                    CURRENTLY_PROCESSING_NODE_PATH_QUEUE.remove(queueKey);
                    Session session = systemProvider.getSession(workspace, repository);
                    if (!session.itemExists(nodePath)) {
                        return;
                    }
                    Node changedNode = (Node)session.getItem(nodePath);
                    boolean isFile = changedNode.isNodeType("nt:file");
                    StatisticData statisticData = this.addModuleName(isFile);
                    this.addOperationName(node, statisticData, isNew, isFile);
                    this.addUUID(changedNode, statisticData);
                    if (isFile) {
                        this.addFileProperties(statisticData, changedNode);
                    }
                    statisticData.setUserId(AnalyticsUtils.getUserIdentityId((String)username));
                    statisticData.addParameter(DOCUMENT_TYPE_PARAM, (Object)changedNode.getPrimaryNodeType().getName());
                    this.addDocumentTitle(changedNode, statisticData);
                    this.addSpaceStatistic(statisticData, nodePath);
                    AnalyticsUtils.addStatisticData((StatisticData)statisticData);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error computing jcr statistics", (Throwable)e);
                }
                finally {
                    systemProvider.close();
                    RequestLifeCycle.end();
                    ExoContainerContext.setCurrentContainer(null);
                }
            });
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled() || PropertyManager.isDevelopping()) {
                LOG.warn((Object)"Error computing jcr statistics", (Throwable)e);
            }
            LOG.warn("Error computing jcr statistics: {}", new Object[]{e.getMessage()});
        }
        return true;
    }

    private void addFileProperties(StatisticData statisticData, Node changedNode) throws RepositoryException {
        String nodeName;
        int index;
        if (changedNode.hasNode("jcr:content")) {
            Node fileMetadataNode = changedNode.getNode("jcr:content");
            if (fileMetadataNode.hasProperty("jcr:mimeType")) {
                statisticData.addParameter(FILE_MIME_TYPE_PARAM, (Object)fileMetadataNode.getProperty("jcr:mimeType").getString());
            }
            if (fileMetadataNode.hasProperty("jcr:data")) {
                statisticData.addParameter(FILE_SIZE_PARAM, (Object)fileMetadataNode.getProperty("jcr:data").getLength());
            }
        }
        if ((index = (nodeName = changedNode.getName()).lastIndexOf(46)) != -1) {
            statisticData.addParameter(FILE_EXTENSION_PARAM, (Object)nodeName.substring(index + 1));
        }
    }

    private void addUUID(Node changedNode, StatisticData statisticData) throws RepositoryException {
        if (changedNode.hasProperty("jcr:uuid")) {
            statisticData.addParameter(UUID_PARAM, (Object)changedNode.getProperty("jcr:uuid").getString());
        }
    }

    private StatisticData addModuleName(boolean isFile) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule(MODULE_DRIVE);
        if (isFile) {
            statisticData.setSubModule(MODULE_DOCUMENT);
        } else {
            statisticData.setSubModule(SUB_MODULE_CONTENT);
        }
        return statisticData;
    }

    private void addOperationName(Node node, StatisticData statisticData, boolean isNew, boolean isFile) throws RepositoryException {
        boolean movedToTrash = this.getTrashService().isInTrash(node);
        String operation = null;
        if (movedToTrash) {
            operation = isFile ? FILE_MOVED_TO_TRASH_OPERATION : DOCUMENT_MOVED_TO_TRASH_OPERATION;
        } else if (isNew) {
            if (!isFile) {
                operation = DOCUMENT_CREATED_OPERATION;
            }
        } else {
            operation = isFile ? FILE_UPDATED_OPERATION : DOCUMENT_UPDATED_OPERATION;
        }
        statisticData.setOperation(operation);
    }

    private void addDocumentTitle(Node managedNode, StatisticData statisticData) throws RepositoryException, UnsupportedEncodingException {
        String title = null;
        title = managedNode.hasProperty("exo:title") ? managedNode.getProperty("exo:title").getString() : (managedNode.hasProperty("exo:name") ? managedNode.getProperty("exo:name").getString() : managedNode.getName());
        try {
            title = URLDecoder.decode(URLDecoder.decode(title, DEFAULT_CHARSET), DEFAULT_CHARSET);
        }
        catch (Exception exception) {
            // empty catch block
        }
        statisticData.addParameter(DOCUMENT_NAME_PARAM, (Object)title);
    }

    private Node getManagedNodeFromParents(Node changedNode) throws RepositoryException {
        Node nodeIndex = changedNode;
        Node managedNode = this.getManagedNode(changedNode);
        while (!StringUtils.equals((CharSequence)"/", (CharSequence)nodeIndex.getPath())) {
            try {
                Node managedNodeTmp = this.getManagedNode(nodeIndex = nodeIndex.getParent());
                if (managedNodeTmp == null) continue;
                managedNode = managedNodeTmp;
            }
            catch (AccessDeniedException e) {
                LOG.trace("User doesn't have access to parent node of '{}'", new Object[]{nodeIndex.getPath(), e});
                break;
            }
        }
        return managedNode;
    }

    private Node getManagedNode(Node node) throws RepositoryException {
        String nodeType = node.getPrimaryNodeType().getName();
        if (!node.isNodeType("nt:resource") && (node.isNodeType("nt:file") || this.getTemplateService().isManagedNodeType(nodeType))) {
            return node;
        }
        return null;
    }

    private void addSpaceStatistic(StatisticData statisticData, String nodePath) {
        String[] nodePathParts;
        if (nodePath.startsWith(GROUPS_SPACES_PARENT_FOLDER) && (nodePathParts = nodePath.split("/")).length > 3) {
            String groupId = "/spaces/" + nodePathParts[3];
            Space space = this.getSpaceService().getSpaceByGroupId(groupId);
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
    }

    private TemplateService getTemplateService() {
        if (this.templateService == null) {
            this.templateService = (TemplateService)this.container.getComponentInstanceOfType(TemplateService.class);
        }
        return this.templateService;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private TrashService getTrashService() {
        if (this.trashService == null) {
            this.trashService = (TrashService)this.container.getComponentInstanceOfType(TrashService.class);
        }
        return this.trashService;
    }

    private static Executor delayedExecutor(long delay, TimeUnit unit) {
        return JCRNodeListener.delayedExecutor(delay, unit, ForkJoinPool.commonPool());
    }

    private static Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        return r -> SCHEDULER.schedule(() -> executor.execute(r), delay, unit);
    }
}

