/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.customization.listeners;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.space.customization.SpaceCustomizationService;

public class CustomizeSpaceDriveListener
extends SpaceListenerPlugin {
    private static final String SPACE_DRIVE_VIEW = "space.drive.view";
    private SpaceCustomizationService spaceCustomizationService = null;
    private String viewNodeName = null;
    private static final Log LOG = ExoLogger.getExoLogger(CustomizeSpaceDriveListener.class);

    public CustomizeSpaceDriveListener(SpaceCustomizationService spaceCustomizationService_, InitParams params) {
        this.spaceCustomizationService = spaceCustomizationService_;
        ValueParam viewParamName = params.getValueParam(SPACE_DRIVE_VIEW);
        if (viewParamName != null) {
            this.viewNodeName = viewParamName.getValue();
        } else {
            LOG.warn((Object)"No such property found: space.drive.view\nPlease make sure to have the correct ECMS view name.");
        }
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        String groupId = event.getSpace().getGroupId();
        String permission = "manager:" + groupId;
        try {
            if (this.viewNodeName != null) {
                this.spaceCustomizationService.editSpaceDriveViewPermissions(this.viewNodeName, permission);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Can not edit view's permissions for view node: null");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not edit view's permission for space drive: " + groupId), (Throwable)e);
        }
    }
}

