/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.customization;

import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceCustomizationService {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceCustomizationService.class);
    private static final String GROUPS_PATH = "groupsPath";
    private static final String ACTIVITY_FOLDER_UPLOAD_NAME = "Activity Stream Documents";
    private SessionProviderService sessionProviderService;
    private NodeHierarchyCreator nodeHierarchyCreator = null;
    private DMSConfiguration dmsConfiguration = null;
    private RepositoryService repositoryService = null;
    private ConfigurationManager configurationManager = null;
    private SpaceService spaceService = null;
    private UserACL userACL = null;
    private String groupsPath;

    public SpaceCustomizationService(SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration, RepositoryService repositoryService, ConfigurationManager configurationManager, UserACL userAcl) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.dmsConfiguration = dmsConfiguration;
        this.repositoryService = repositoryService;
        this.userACL = userAcl;
        this.configurationManager = configurationManager;
        this.sessionProviderService = sessionProviderService;
        this.groupsPath = nodeHierarchyCreator.getJcrPath(GROUPS_PATH);
        if (this.groupsPath.lastIndexOf("/") == this.groupsPath.length() - 1) {
            this.groupsPath = this.groupsPath.substring(0, this.groupsPath.lastIndexOf("/"));
        }
    }

    public void editSpaceDriveViewPermissions(String viewNodeName, String permission) throws RepositoryException {
        DMSRepositoryConfiguration dmsRepoConfig;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to add permission " + permission + " for ECMS view " + viewNodeName));
        }
        String viewsPath = this.nodeHierarchyCreator.getJcrPath("userViewsPath");
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = manageableRepository.getSystemSession((dmsRepoConfig = this.dmsConfiguration.getConfig()).getSystemWorkspace());
        Node viewHomeNode = (Node)session.getItem(viewsPath);
        if (viewHomeNode.hasNode(viewNodeName)) {
            Node contentNode = viewHomeNode.getNode(viewNodeName);
            String contentNodePermissions = contentNode.getProperty("exo:accessPermissions").getString();
            contentNode.setProperty("exo:accessPermissions", contentNodePermissions.concat(",").concat(permission));
            viewHomeNode.save();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Permission " + permission + " added with success to ECMS view " + viewNodeName));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Can not find view node: " + viewNodeName));
        }
    }

    public void deployContentToSpaceDrive(SessionProvider sessionProvider, String spaceId, DeploymentDescriptor deploymentDescriptor) throws Exception {
        String sourcePath = deploymentDescriptor.getSourcePath();
        LOG.info((Object)("Deploying '" + sourcePath + "'content to '" + spaceId + "' Space JCR location"));
        Boolean cleanupPublication = deploymentDescriptor.getCleanupPublication();
        InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
        ManageableRepository repository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
        String targetNodePath = deploymentDescriptor.getTarget().getNodePath();
        if (targetNodePath.indexOf("/") == 0) {
            targetNodePath = targetNodePath.replaceFirst("/", "");
        }
        if (targetNodePath.lastIndexOf("/") == targetNodePath.length() - 1) {
            targetNodePath = targetNodePath.substring(0, targetNodePath.lastIndexOf("/"));
        }
        if (!targetNodePath.equals("")) {
            Node spaceRootNode = (Node)session.getItem(this.groupsPath + spaceId);
            Utils.makePath((Node)spaceRootNode, (String)targetNodePath, (String)"nt:unstructured");
        }
        String fullTargetNodePath = this.groupsPath + spaceId + "/" + targetNodePath;
        Node parentTargetNode = (Node)session.getItem(fullTargetNodePath);
        NodeIterator nodeIterator = parentTargetNode.getNodes();
        ArrayList<String> initialChildNodesUUID = new ArrayList<String>();
        ArrayList<String> initialChildNodesNames = new ArrayList<String>();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            String uuid = null;
            try {
                uuid = node.getUUID();
            }
            catch (Exception exception) {
                continue;
            }
            initialChildNodesUUID.add(uuid);
            initialChildNodesNames.add(node.getName());
        }
        session.importXML(fullTargetNodePath, inputStream, 0);
        parentTargetNode = (Node)session.getItem(fullTargetNodePath);
        nodeIterator = parentTargetNode.getNodes();
        ArrayList<ExtendedNode> newChildNodesUUID = new ArrayList<ExtendedNode>();
        while (nodeIterator.hasNext()) {
            ExtendedNode childNode = (ExtendedNode)nodeIterator.nextNode();
            String uuid = null;
            try {
                uuid = childNode.getUUID();
            }
            catch (Exception exception) {
                continue;
            }
            if (initialChildNodesUUID.contains(uuid)) continue;
            if (initialChildNodesNames.contains(childNode.getName())) {
                LOG.info((Object)(childNode.getName() + " already exists under " + fullTargetNodePath + ". This node will not be imported!"));
                childNode.remove();
                continue;
            }
            newChildNodesUUID.add(childNode);
        }
        String spaceMembershipManager = this.userACL.getAdminMSType() + ":" + spaceId;
        for (ExtendedNode extendedNode : newChildNodesUUID) {
            if (extendedNode.isNodeType("exo:privilegeable")) {
                extendedNode.clearACL();
            } else if (extendedNode.canAddMixin("exo:privilegeable")) {
                extendedNode.addMixin("exo:privilegeable");
                extendedNode.clearACL();
            } else {
                throw new IllegalStateException("Can't change permissions on node imported to the added Space.");
            }
            extendedNode.setPermission(IdentityConstants.ANY, new String[]{"read"});
            extendedNode.setPermission(spaceMembershipManager, PermissionType.ALL);
            if (!cleanupPublication.booleanValue() || !extendedNode.hasProperty("publication:liveRevision") || !extendedNode.hasProperty("publication:currentState")) continue;
            LOG.info((Object)("\"" + extendedNode.getName() + "\" publication lifecycle has been cleaned up"));
            extendedNode.setProperty("publication:liveRevision", "");
            extendedNode.setProperty("publication:currentState", "published");
        }
        session.save();
        session.logout();
        LOG.info((Object)(deploymentDescriptor.getSourcePath() + " is deployed succesfully into " + fullTargetNodePath));
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    public void createSpaceDefaultFolders(String groupId) throws Exception {
        String groupPath;
        String spaceParentPath;
        ManageableRepository currentRepository;
        String workspaceName;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(workspaceName = (currentRepository = this.repositoryService.getCurrentRepository()).getConfiguration().getDefaultWorkspaceName(), currentRepository);
        if (!session.itemExists(spaceParentPath = (groupPath = this.nodeHierarchyCreator.getJcrPath(GROUPS_PATH)) + groupId + "/Documents")) {
            throw new IllegalStateException("Root node of space '" + spaceParentPath + "' doesn't exist");
        }
        Node parentNode = (Node)session.getItem(spaceParentPath);
        if (!parentNode.hasNode(ACTIVITY_FOLDER_UPLOAD_NAME)) {
            parentNode.addNode(ACTIVITY_FOLDER_UPLOAD_NAME);
            session.save();
        }
    }
}

