/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.util.VersionHistoryImporter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Utils {
    public static final String MAPPING_FILE = "mapping.properties";
    private static final Log LOG = ExoLogger.getLogger(Utils.class);

    public static Node makePath(Node rootNode, String path, String nodetype) throws PathNotFoundException, RepositoryException {
        return Utils.makePath(rootNode, path, nodetype, null);
    }

    public static Node makePath(Node rootNode, String path, String nodetype, Map permissions) throws PathNotFoundException, RepositoryException {
        String[] tokens = path.split("/");
        Node node = rootNode;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.length() <= 0) continue;
            if (node.hasNode(token)) {
                node = node.getNode(token);
                continue;
            }
            if ((node = node.addNode(token, nodetype)).canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            if (permissions == null) continue;
            ((ExtendedNode)node).setPermissions(permissions);
        }
        return node;
    }

    public static void processImportHistory(Node currentNode, InputStream versionHistorySourceStream, Map<String, String> mapHistoryValue) throws Exception {
        for (String uuid : mapHistoryValue.keySet()) {
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(versionHistorySourceStream));
            byte[] data = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                int available = -1;
                if (entry.getName().equals(uuid + ".xml")) {
                    while ((available = zipInputStream.read(data, 0, 1024)) > -1) {
                        out.write(data, 0, available);
                    }
                    try {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
                        String value = mapHistoryValue.get(uuid);
                        Node versionableNode = currentNode.getSession().getNodeByUUID(uuid);
                        Utils.importHistory((NodeImpl)versionableNode, inputStream, Utils.getBaseVersionUUID(value), Utils.getPredecessors(value), Utils.getVersionHistory(value));
                        currentNode.getSession().save();
                    }
                    catch (ItemNotFoundException item) {
                        currentNode.getSession().refresh(false);
                        LOG.error((Object)("Can not found versionable node" + String.valueOf((Object)item)), (Throwable)item);
                    }
                    catch (RepositoryException e) {
                        currentNode.getSession().refresh(false);
                        LOG.error((Object)("Import version history failed " + String.valueOf((Object)e)), (Throwable)e);
                    }
                    zipInputStream.closeEntry();
                    entry = zipInputStream.getNextEntry();
                    continue;
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
            out.close();
            zipInputStream.close();
        }
    }

    private static void importHistory(NodeImpl versionableNode, InputStream versionHistoryStream, String baseVersionUuid, String[] predecessors, String versionHistory) throws RepositoryException, IOException {
        VersionHistoryImporter versionHistoryImporter = new VersionHistoryImporter(versionableNode, versionHistoryStream, baseVersionUuid, predecessors, versionHistory);
        versionHistoryImporter.doImport();
    }

    public static Map<String, String> getMapImportHistory(InputStream importHistorySourceStream) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(importHistorySourceStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        ZipEntry entry = zipInputStream.getNextEntry();
        HashMap<String, String> mapHistoryValue = new HashMap<String, String>();
        while (entry != null) {
            int available = -1;
            if (entry.getName().equals(MAPPING_FILE)) {
                String strLine;
                while ((available = zipInputStream.read(data, 0, 1024)) > -1) {
                    out.write(data, 0, available);
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((strLine = br.readLine()) != null) {
                    if (strLine.indexOf("=") <= -1) continue;
                    mapHistoryValue.put(strLine.split("=")[0], strLine.split("=")[1]);
                }
                ((InputStream)inputStream).close();
                zipInputStream.closeEntry();
                break;
            }
            entry = zipInputStream.getNextEntry();
        }
        out.close();
        zipInputStream.close();
        return mapHistoryValue;
    }

    private static String getBaseVersionUUID(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        return arrHistoryValue[1];
    }

    private static String[] getPredecessors(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        String strPredecessors = arrHistoryValue[1];
        if (strPredecessors.indexOf(",") > -1) {
            return strPredecessors.split(",");
        }
        return new String[]{strPredecessors};
    }

    private static String getVersionHistory(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        return arrHistoryValue[0];
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)CommonsUtils.getService(clazz);
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        return (T)CommonsUtils.getService(clazz, (String)containerName);
    }
}

