/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;

public class RobotsHandler
extends WebRequestHandler {
    private String portalName = null;

    public String getHandlerName() {
        return "robots";
    }

    public boolean execute(ControllerContext context) throws Exception {
        this.portalName = context.getParameter(QualifiedName.create((String)"gtn", (String)"sitename"));
        this.execute(context.getController(), context.getRequest(), context.getResponse());
        return true;
    }

    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String robotsContent = "";
        if (this.portalName != null && this.portalName.length() > 0) {
            SEOService seoService = WCMCoreUtils.getService(SEOService.class);
            robotsContent = seoService.getRobots(this.portalName);
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            out.println(robotsContent);
        }
    }

    public boolean getRequiresLifeCycle() {
        return true;
    }
}

