/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.security.ConversationState;

public class PublicationUtil {
    public static final String HISTORY_SEPARATOR = "; ";
    public static final String APPLICATION_SEPARATOR = "@";
    public static final String URI_SEPARATOR = "/";

    public static List<UserNode> findUserNodeByPageId(UserNode rootNode, String pageId) throws Exception {
        ArrayList<UserNode> allUserNodes = new ArrayList<UserNode>();
        PublicationUtil.findUserNodeByPageId(rootNode, pageId, allUserNodes);
        return allUserNodes;
    }

    public static void findUserNodeByPageId(UserNode userNode, String pageId, List<UserNode> allUserNodes) throws Exception {
        for (UserNode node : userNode.getChildren()) {
            if (node.getPageRef().equals((Object)pageId)) {
                allUserNodes.add(node);
                continue;
            }
            PublicationUtil.findUserNodeByPageId(node, pageId, allUserNodes);
        }
    }

    public static List<String> findAppInstancesByName(Page page, String applicationName) {
        ArrayList<String> results = new ArrayList<String>();
        PublicationUtil.findAppInstancesByContainerAndName((Container)page, applicationName, results);
        return results;
    }

    private static void findAppInstancesByContainerAndName(Container container, String applicationName, List<String> results) {
        ArrayList chidren = container.getChildren();
        if (chidren == null) {
            return;
        }
        for (ModelObject object : chidren) {
            if (object instanceof Application) {
                Application application = (Application)Application.class.cast(object);
                if (!application.getId().contains(applicationName)) continue;
                results.add(application.getId());
                continue;
            }
            if (!(object instanceof Container)) continue;
            Container child = (Container)Container.class.cast(object);
            PublicationUtil.findAppInstancesByContainerAndName(child, applicationName, results);
        }
    }

    private static void removedAppInstancesInContainerByNames(Container container, List<String> removingApplicationIds) {
        ArrayList<Object> childrenTmp = new ArrayList<Object>();
        ArrayList chidren = container.getChildren();
        if (chidren == null) {
            return;
        }
        for (ModelObject object : chidren) {
            if (object instanceof Application) {
                Application application = (Application)Application.class.cast(object);
                if (removingApplicationIds.contains(application.getId())) continue;
                childrenTmp.add(object);
                continue;
            }
            if (!(object instanceof Container)) continue;
            Container child = (Container)Container.class.cast(object);
            PublicationUtil.removedAppInstancesInContainerByNames(child, removingApplicationIds);
            childrenTmp.add(child);
        }
    }

    public static List<String> getValuesAsString(Node node, String propName) throws Exception {
        if (!node.hasProperty(propName)) {
            return new ArrayList<String>();
        }
        ArrayList<String> results = new ArrayList<String>();
        try {
            for (Value value : node.getProperty(propName).getValues()) {
                results.add(value.getString());
            }
        }
        catch (ValueFormatException ex) {
            results.add(node.getProperty(propName).getValue().getString());
        }
        return results;
    }

    public static Value[] toValues(ValueFactory factory, List<String> values) {
        ArrayList<Value> list = new ArrayList<Value>();
        for (String value : values) {
            list.add(factory.createValue(value));
        }
        return list.toArray(new Value[list.size()]);
    }

    public static void removeApplicationFromPage(Page page, List<String> removedApplicationIds) {
        PublicationUtil.removedAppInstancesInContainerByNames((Container)page, removedApplicationIds);
    }

    public static List<String> getListApplicationIdByPage(Page page, String portletName) {
        return PublicationUtil.findAppInstancesByName(page, portletName);
    }

    public static String setMixedNavigationUri(String portalName, String pageNodeUri) {
        return URI_SEPARATOR + portalName + URI_SEPARATOR + pageNodeUri;
    }

    public static String[] parseMixedNavigationUri(String mixedNavigationUri) {
        String[] mixedNavigationUris = new String[2];
        int first = 1;
        int second = mixedNavigationUri.indexOf(URI_SEPARATOR, first);
        mixedNavigationUris[0] = mixedNavigationUri.substring(first, second);
        mixedNavigationUris[1] = mixedNavigationUri.substring(second + URI_SEPARATOR.length(), mixedNavigationUri.length());
        return mixedNavigationUris;
    }

    public static String setMixedApplicationId(String pageId, String applicationId) {
        return pageId + APPLICATION_SEPARATOR + applicationId;
    }

    public static String[] parseMixedApplicationId(String mixedApplicationId) {
        return mixedApplicationId.split(APPLICATION_SEPARATOR);
    }

    public static boolean isNodeContentPublishedToPageNode(Node contentNode, String navNodeURI) throws Exception {
        String nodeURI = navNodeURI.replace(URI_SEPARATOR + Util.getPortalRequestContext().getPortalOwner() + URI_SEPARATOR, "");
        UserNode userNode = ((UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class)).getSiteNodeOrGlobalNode(Util.getUIPortal().getSiteKey().getTypeName(), Util.getUIPortal().getSiteKey().getName(), nodeURI, ConversationState.getCurrent().getIdentity().getUserId());
        if (userNode == null || userNode.getPageRef() == null) {
            return false;
        }
        return PublicationUtil.getValuesAsString(contentNode, "publication:webPageIDs").contains(userNode.getPageRef());
    }

    public static ArrayList<NodeContext<?>> convertAllNodeContextToList(NodeContext<?> rootNodeContext) {
        if (rootNodeContext == null || rootNodeContext.getNodes() == null) {
            return null;
        }
        ArrayList nodeContextList = new ArrayList();
        for (NodeContext context : rootNodeContext.getNodes()) {
            nodeContextList.add(context);
            nodeContextList.addAll(PublicationUtil.convertAllNodeContextToList(context));
        }
        return nodeContextList;
    }

    public static StringBuilder buildUserNodeURI(NodeContext<?> context) {
        NodeContext parent = (NodeContext)context.getParentNode();
        if (parent != null) {
            StringBuilder builder = PublicationUtil.buildUserNodeURI(parent);
            if (builder.length() > 0) {
                builder.append('/');
            }
            return builder.append(context.getName());
        }
        return new StringBuilder();
    }
}

