/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UICategoryManagerSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UIConstraintsForm;
import org.exoplatform.ecm.webui.component.explorer.search.UINodeTypeSelectForm;
import org.exoplatform.ecm.webui.component.explorer.search.UISaveQueryForm;
import org.exoplatform.ecm.webui.component.explorer.search.UISelectPropertyForm;
import org.exoplatform.ecm.webui.component.explorer.search.UISimpleSearch;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UISearchContainer
extends UIContainer {
    public static final String METADATA_POPUP = "MetadataPopup";
    public static final String NODETYPE_POPUP = "NodeTypePopup";
    public static final String SAVEQUERY_POPUP = "SaveQueryPopup";
    public static final String CATEGORY_POPUP = "CategoryPopup";

    public UISearchContainer() throws Exception {
        this.addChild(UISimpleSearch.class, null, null);
        UIPopupContainer popup = (UIPopupContainer)this.addChild(UIPopupContainer.class, null, METADATA_POPUP);
        ((UIPopupWindow)popup.getChild(UIPopupWindow.class)).setId("MetadataPopup_Popup");
    }

    public void initMetadataPopup(String fieldName) throws Exception {
        UIPopupContainer uiPopup = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId(fieldName + METADATA_POPUP);
        UISelectPropertyForm uiSelectForm = (UISelectPropertyForm)this.createUIComponent(UISelectPropertyForm.class, null, null);
        uiSelectForm.setFieldName(fieldName);
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setShowMask(true);
        uiPopup.activate((UIComponent)uiSelectForm, 500, 450);
    }

    public void initNodeTypePopup() throws Exception {
        UIPopupContainer uiPopup = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId(NODETYPE_POPUP);
        UINodeTypeSelectForm uiSelectForm = (UINodeTypeSelectForm)this.createUIComponent(UINodeTypeSelectForm.class, null, null);
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setShowMask(true);
        uiPopup.activate((UIComponent)uiSelectForm, 400, 400);
        uiSelectForm.setRenderNodeTypes();
    }

    public void initCategoryPopup() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String repository = uiExplorer.getRepositoryName();
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspaceName = dmsConfiguration.getConfig().getSystemWorkspace();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiExplorer.getApplicationComponent(NodeHierarchyCreator.class);
        uiExplorer.setIsHidePopup(true);
        UICategoryManagerSearch uiCategoryManagerSearch = (UICategoryManagerSearch)uiExplorer.createUIComponent(UICategoryManagerSearch.class, null, null);
        UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiCategoryManagerSearch.getChild(UIOneTaxonomySelector.class);
        uiOneTaxonomySelector.setIsDisable(workspaceName, true);
        String rootTreePath = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
        Session session = uiExplorer.getSessionByWorkspace(workspaceName);
        Node rootTree = (Node)session.getItem(rootTreePath);
        NodeIterator childrenIterator = rootTree.getNodes();
        if (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            rootTreePath = childNode.getPath();
        }
        uiOneTaxonomySelector.setRootNodeLocation(repository, workspaceName, rootTreePath);
        uiOneTaxonomySelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
        uiOneTaxonomySelector.init(uiExplorer.getSystemProvider());
        UIConstraintsForm uiConstraintsForm = (UIConstraintsForm)this.findFirstComponentOfType(UIConstraintsForm.class);
        uiOneTaxonomySelector.setSourceComponent((UIComponent)uiConstraintsForm, new String[]{"categoryType"});
        UIPopupContainer UIPopupContainer2 = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        ((UIPopupWindow)UIPopupContainer2.getChild(UIPopupWindow.class)).setId(CATEGORY_POPUP);
        UIPopupContainer2.activate((UIComponent)uiCategoryManagerSearch, 650, 500);
    }

    public void initSaveQueryPopup(String statement, boolean isSimpleSearch, String queryType) throws Exception {
        UIPopupContainer uiPopup = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId(SAVEQUERY_POPUP);
        UISaveQueryForm uiSaveQueryForm = (UISaveQueryForm)this.createUIComponent(UISaveQueryForm.class, null, null);
        uiSaveQueryForm.setStatement(statement);
        uiSaveQueryForm.setSimpleSearch(isSimpleSearch);
        uiSaveQueryForm.setQueryType(queryType);
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setShowMask(true);
        uiPopup.activate((UIComponent)uiSaveQueryForm, 420, 200);
    }
}

