/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecms.legacy.search.data.SearchContext;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.connector.BaseContentSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class DocumentSearchServiceConnector
extends BaseContentSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger((String)DocumentSearchServiceConnector.class.getName());

    public DocumentSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
        this.setEnabledForAnonymous(true);
    }

    @Override
    protected String[] getSearchedDocTypes() {
        List docTypes;
        block2: {
            docTypes = null;
            try {
                docTypes = ((TemplateService)WCMCoreUtils.getService(TemplateService.class)).getDocumentTemplates();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
        docTypes.add("exo:tagged");
        docTypes.remove("nt:file");
        return docTypes.toArray(new String[0]);
    }

    @Override
    protected String[] getNodeTypes() {
        return null;
    }

    @Override
    protected ResultNode filterNode(ResultNode node) throws RepositoryException {
        return node.isNodeType("nt:file") ? null : node;
    }

    @Override
    protected String getPath(ResultNode node, SearchContext context) throws Exception {
        Object url = "#";
        String handler = WCMCoreUtils.getPortalName();
        if (StringUtils.isNotEmpty((CharSequence)context.getSiteName())) {
            String siteType = StringUtils.isEmpty((CharSequence)context.getSiteType()) ? SiteType.PORTAL.toString() : context.getSiteType().toUpperCase();
            SiteKey siteKey = new SiteKey(SiteType.valueOf((String)siteType), context.getSiteName());
            DriveData driveData = this.documentService.getDriveOfNode(node.getPath(), ConversationState.getCurrent().getIdentity().getUserId(), Utils.getMemberships());
            if (StringUtils.isNotBlank((CharSequence)siteKey.getName())) {
                String pageName = this.getPageName(siteKey);
                if (StringUtils.isNotBlank((CharSequence)pageName)) {
                    siteKey = SiteKey.portal((String)(context.getSiteName() != null ? context.getSiteName() : "intranet"));
                    pageName = this.getPageName(siteKey);
                }
                try {
                    url = "/" + handler + context.handler(handler).lang("").siteName(siteKey.getName()).siteType(SiteType.PORTAL.getName()).path(pageName + "?path=" + driveData.getName() + "/" + node.getPath()).renderLink();
                }
                catch (Exception e) {
                    LOG.debug((Object)"The current user does not have the needed permission to get the requested document");
                    return null;
                }
            }
        }
        return URLDecoder.decode((String)url, "UTF-8");
    }

    @Override
    protected String getPreviewUrl(ResultNode node, SearchContext context) throws Exception {
        String restContextName = WCMCoreUtils.getRestContextName();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        String workspaceName = node.getSession().getWorkspace().getName();
        StringBuffer downloadUrl = new StringBuffer();
        downloadUrl.append('/').append(restContextName).append("/jcr/").append(WCMCoreUtils.getRepository().getConfiguration().getName()).append('/').append(workspaceName).append(node.getPath());
        String authorUsername = null;
        if (node.hasProperty("exo:owner")) {
            authorUsername = node.getProperty("exo:owner").getString();
        }
        StringBuilder url = new StringBuilder("javascript:require(['SHARED/documentPreview'], function(documentPreview) {documentPreview.init({doc:{");
        if (node.isNodeType("mix:referenceable")) {
            url.append("id:'").append(node.getUUID()).append("',");
        }
        String title = StringEscapeUtils.escapeHtml4((String)this.getTitleResult(node)).replace("'", "\\'");
        url.append("fileType:'").append(this.getFileType(node)).append("',");
        url.append("title:'").append(title).append("',");
        url.append("path:'").append(node.getPath()).append("', repository:'").append(repositoryName).append("', workspace:'").append(workspaceName).append("', downloadUrl:'").append(downloadUrl.toString()).append("', openUrl:'").append(this.documentService.getLinkInDocumentsApp(node.getPath())).append("'}");
        if (authorUsername != null) {
            url.append(",author:{username:'").append(authorUsername).append("'}");
        }
        url.append("})});void(0);");
        return url.toString();
    }

    private String getPageName(SiteKey siteKey) throws Exception {
        NavigationContext nav;
        NavigationService navService = (NavigationService)WCMCoreUtils.getService(NavigationService.class);
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav = navService.loadNavigation(siteKey), Scope.ALL, null);
        if (parentNodeCtx.getSize() >= 1) {
            Collection children = parentNodeCtx.getNodes();
            if (siteKey.getType() == SiteType.GROUP) {
                children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
            }
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext()) {
                child = (NodeContext)it.next();
                if (!this.hasPortlet(child, "FileExplorerPortlet")) continue;
                return child.getName();
            }
        }
        return "";
    }

    private boolean hasPortlet(NodeContext<?> pageCt, String plName) {
        if (plName == null) {
            return false;
        }
        LayoutService ds = (LayoutService)WCMCoreUtils.getService(LayoutService.class);
        try {
            for (ModelObject mo : ds.getPage(pageCt.getState().getPageRef().format()).getChildren()) {
                if (!this.containApp(mo, plName)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    private boolean containApp(ModelObject mo, String plName) {
        block6: {
            LayoutService ds = (LayoutService)WCMCoreUtils.getService(LayoutService.class);
            if (mo instanceof Application) {
                try {
                    if (ds.getId(((Application)mo).getState()).contains(plName)) {
                        return true;
                    }
                    break block6;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (mo instanceof Container) {
                for (ModelObject m : ((Container)mo).getChildren()) {
                    if (!this.containApp(m, plName)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

