/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/resource")
@Produces(value={"application/json"})
public class ResourceService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(ResourceService.class);
    protected final ResourceBundleService resourceService;

    public ResourceService(ResourceBundleService resourceService) {
        this.resourceService = resourceService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/bundle")
    public Response getBundle(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        Locale locale = request.getLocale();
        try {
            ResourceBundle bundle = this.resourceService.getResourceBundle("locale.clouddrive.CloudDrive", locale);
            if (bundle != null) {
                HashMap<String, String> bundleMap = new HashMap<String, String>();
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String value = bundle.getString(key);
                    bundleMap.put(key, value);
                }
                return Response.ok().entity((Object)new LocaleBundle(locale.getLanguage(), locale.getCountry(), bundleMap)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Bundle not found for " + locale.toLanguageTag())).build();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error returning locale bundle for " + String.valueOf(locale) + ": " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error getting bundle for " + locale.toLanguageTag())).build();
        }
    }

    public static class LocaleBundle {
        protected final Map<String, String> data;
        protected final String language;
        protected final String country;

        protected LocaleBundle(String language, String country, Map<String, String> data) {
            this.language = language;
            this.country = country;
            this.data = data;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getCountry() {
            return this.country;
        }
    }
}

