/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.viewer;

import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.ecm.webui.viewer.CloudFileViewer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.webui.BaseCloudDriveForm;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

public abstract class AbstractFileForm
extends BaseCloudDriveForm
implements CloudFileViewer {
    protected CloudDrive drive;
    protected CloudFile file;

    public void processRender(WebuiRequestContext context) throws Exception {
        this.initContext();
        Object obj = context.getAttribute(CloudDrive.class);
        if (obj != null) {
            CloudDrive drive = (CloudDrive)obj;
            obj = context.getAttribute(CloudFile.class);
            if (obj != null) {
                this.initFile(drive, (CloudFile)obj);
            }
        }
        super.processRender(context);
    }

    public void initFile(CloudDrive drive, CloudFile file) {
        this.drive = drive;
        this.file = file;
    }

    public CloudDrive getDrive() {
        return this.drive;
    }

    public CloudFile getFile() {
        return this.file;
    }

    public boolean isViewable() {
        String mimeType = this.file.getType();
        return !mimeType.startsWith("application/octet-stream");
    }

    public String appRes(String key) {
        Locale locale = Util.getPortalRequestContext().getLocale();
        ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(new String[]{"locale.clouddrive.CloudDrive", "locale.ecm.views", this.localeFile()}, locale, ((Object)((Object)this)).getClass().getClassLoader());
        return resourceBundle.getString(key);
    }

    protected abstract String localeFile();
}

