/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.skin.XSkinService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMSkinResourceResolver
implements ResourceResolver {
    private SkinService skinService;
    private LivePortalManagerService livePortalService;
    private static final Log LOG = ExoLogger.getLogger((String)WCMSkinResourceResolver.class.getName());

    public WCMSkinResourceResolver(SkinService skinService, LivePortalManagerService livePortalService) {
        this.skinService = skinService;
        this.livePortalService = livePortalService;
    }

    public Resource resolve(String path) {
        if (!path.matches("/(.*)/css/jcr/(.*)/(.*)/(.*)/(.*).css")) {
            return null;
        }
        Map<String, String> params = XSkinService.getSkinParams(path);
        String skinModule = params.get("moduleName");
        String siteName = params.get("siteName");
        String skinName = params.get("skinName");
        if (!skinModule.matches("(.*)/(.*)")) {
            return null;
        }
        String cssPath = null;
        SkinConfig portalSkinConfig = this.skinService.getSkin(skinModule, skinName);
        if (portalSkinConfig != null) {
            cssPath = portalSkinConfig.getCSSPath();
        }
        if (cssPath == null) {
            for (SkinConfig skinConfig : this.skinService.getPortalSkins(skinName)) {
                if (!skinConfig.getModule().equals(skinModule)) continue;
                cssPath = skinConfig.getCSSPath();
                break;
            }
        }
        try {
            Node portalNode = this.livePortalService.getLivePortal(WCMCoreUtils.getSystemSessionProvider(), siteName);
            String pureCssData = WCMCoreUtils.getSiteGlobalActiveStylesheet(portalNode);
            final String cssData = pureCssData.replaceAll("@import(.*)[^/]*.css(.*);", "");
            if (cssData == null) {
                return null;
            }
            return new Resource(this, cssPath){

                public Reader read() {
                    return new StringReader(cssData);
                }
            };
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error happens", (Throwable)e);
            }
            return null;
        }
    }
}

