/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class LocalCloudFile
implements CloudFile {
    protected static final Log LOG = ExoLogger.getLogger(LocalCloudFile.class);
    private String modifiedLocal;
    private String modifiedRemote;

    public void initModified(Locale locale) {
        this.modifiedLocal = this.formatLocalizedDate(this.getLocalModifiedDate(), locale);
        this.modifiedRemote = this.formatLocalizedDate(this.getModifiedDate(), locale);
    }

    public abstract Calendar getLocalModifiedDate();

    private String formatLocalizedDate(Calendar date, Locale locale) {
        if (date != null && locale != null) {
            DateFormat dateFormat = SimpleDateFormat.getDateInstance(3, locale);
            return dateFormat.format(date.getTime());
        }
        return null;
    }

    public String getModifiedRemote() {
        return this.modifiedRemote;
    }

    public String getModifiedLocal() {
        return this.modifiedLocal;
    }

    @Override
    public final boolean isConnected() {
        return true;
    }
}

