/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.metadata.model.MetadataItem;

public class DocumentsMetadataListener
extends Listener<Long, MetadataItem> {
    private final IndexingService indexingService;
    private static final String FILE_METADATA_OBJECT_TYPE = "file";

    public DocumentsMetadataListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void onEvent(Event<Long, MetadataItem> event) throws Exception {
        MetadataItem metadataItem = (MetadataItem)event.getData();
        String objectType = ((MetadataItem)event.getData()).getObjectType();
        String objectId = metadataItem.getObjectId();
        if (StringUtils.equals((CharSequence)objectType, (CharSequence)FILE_METADATA_OBJECT_TYPE)) {
            this.indexingService.reindex(FILE_METADATA_OBJECT_TYPE, objectId);
        }
    }
}

