/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExtendedMimeTypeResolver {
    protected static final Log LOG = ExoLogger.getLogger(ExtendedMimeTypeResolver.class);
    public static final String X_TYPE_MODE = "x-type-mode";
    protected final ConfigurationManager configService;
    protected final Map<String, List<String>> mimeTypes = new HashMap<String, List<String>>();
    protected final Map<String, List<String>> extentions = new HashMap<String, List<String>>();
    protected final Map<String, Set<String>> modes = new LinkedHashMap<String, Set<String>>();
    protected final MimeTypeResolver resolver;

    public ExtendedMimeTypeResolver(ConfigurationManager configService, InitParams params) throws NullPointerException {
        this.configService = configService;
        this.resolver = new MimeTypeResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPlugin(MimeTypeMap typesMap) {
        try {
            for (String path : typesMap.getPaths()) {
                try {
                    Scanner scanner = null;
                    InputStream stream = this.configService.getInputStream(path);
                    if (stream != null) {
                        scanner = new Scanner(stream, "ISO-8859-1");
                    }
                    if (scanner == null) {
                        LOG.warn((Object)("Cannot read extended mimetypes from path " + path));
                        continue;
                    }
                    try {
                        while (scanner.hasNextLine()) {
                            this.processLine(scanner.nextLine());
                        }
                    }
                    finally {
                        scanner.close();
                    }
                }
                catch (Exception e) {
                    throw new IOException("Error loadinng extended mimetypes from path " + path + ": " + e.getMessage(), e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new InternalError("Unable to load extended mimetypes: " + e.toString());
        }
    }

    public String getMimeType(String filename) {
        String mimeType = this.resolver.getMimeType(filename);
        if (this.resolver.getDefaultMimeType().equals(mimeType)) {
            List<String> values;
            String ext = filename.substring(filename.lastIndexOf(".") + 1);
            if (ext.isEmpty()) {
                ext = filename;
            }
            mimeType = (values = this.mimeTypes.get(ext.toLowerCase())) == null ? mimeType : values.get(0);
        }
        return mimeType;
    }

    public String getMimeType(String filename, InputStream is) {
        String mimeType = this.getMimeType(filename);
        if (this.resolver.getDefaultMimeType().equals(mimeType)) {
            mimeType = this.resolver.getMimeType(filename, is);
        }
        return mimeType;
    }

    public String getExtension(String mimeType) {
        String extension = this.resolver.getExtension(mimeType);
        if (extension.length() == 0) {
            if ((mimeType = mimeType.toLowerCase()).isEmpty() || mimeType.equals(this.resolver.getDefaultMimeType())) {
                return "";
            }
            List<String> values = this.extentions.get(mimeType);
            if (values == null) {
                return "";
            }
            String resultExt = "";
            for (String ext : values) {
                if (mimeType.endsWith(ext)) {
                    return ext;
                }
                if (!resultExt.isEmpty()) continue;
                resultExt = ext;
            }
            extension = resultExt;
        }
        return extension;
    }

    public String getDefaultMimeType() {
        return this.resolver.getDefaultMimeType();
    }

    public void setDefaultMimeType(String type) {
        this.resolver.setDefaultMimeType(type);
    }

    public String getMimeTypeMode(String type) {
        return this.getMimeTypeMode(type, null);
    }

    public String getMimeTypeMode(String type, String name) {
        if (type == null && name != null) {
            type = this.getMimeType(name);
        }
        if (type != null) {
            try {
                boolean tryResolved;
                do {
                    tryResolved = false;
                    MimeType mimeType = new MimeType(type);
                    String mode = mimeType.getParameter(X_TYPE_MODE);
                    if (mode == null || mode.length() == 0) {
                        Set<String> modeList = this.modes.get(mimeType.getBaseType());
                        if (modeList != null && modeList.size() == 1) {
                            return modeList.iterator().next();
                        }
                        if (name != null) {
                            type = this.getMimeType(name);
                            tryResolved = true;
                            name = null;
                            continue;
                        }
                        if (modeList == null || modeList.size() <= 0) continue;
                        return modeList.iterator().next();
                    }
                    return mode;
                } while (type != null && tryResolved);
            }
            catch (MimeTypeParseException e) {
                LOG.warn((Object)("Error parsing mimetype " + type + ": " + e.getMessage()));
            }
        }
        return null;
    }

    protected void processLine(String aLine) {
        aLine = aLine.toLowerCase();
        int p = aLine.indexOf("=");
        String ext = aLine.substring(0, p);
        String mimetype = aLine.substring(p + 1);
        try {
            MimeType mimeType = new MimeType(mimetype);
            String mode = mimeType.getParameter(X_TYPE_MODE);
            if (mode != null && mode.length() > 0) {
                String baseType = mimeType.getBaseType();
                Set<String> modeList = this.modes.get(baseType);
                if (modeList == null) {
                    modeList = new LinkedHashSet<String>();
                }
                modeList.add(mode);
                this.modes.put(baseType, modeList);
            }
        }
        catch (MimeTypeParseException e) {
            LOG.warn((Object)("Error parsing mimetype " + mimetype + ": " + e.getMessage()));
        }
        List<String> values = this.mimeTypes.get(ext);
        if (values == null) {
            values = new ArrayList<String>();
            this.mimeTypes.put(ext, values);
        }
        values.add(mimetype);
        values = this.extentions.get(mimetype);
        if (values == null) {
            values = new ArrayList<String>();
            this.extentions.put(mimetype, values);
        }
        values.add(ext);
    }

    public static class MimeTypeMap
    extends BaseComponentPlugin {
        protected final List<String> paths;

        public MimeTypeMap(InitParams params) throws ConfigurationException {
            ArrayList<String> paths;
            ValuesParam param = params.getValuesParam("mimetypes-properties");
            if (param != null) {
                paths = new ArrayList<String>();
                for (Object v : param.getValues()) {
                    if (!(v instanceof String)) continue;
                    paths.add((String)v);
                }
            } else {
                throw new ConfigurationException("Values param mimetypes-properties required in " + ((Object)((Object)this)).getClass().getName() + " plugin");
            }
            this.paths = paths;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }
}

