/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.RepositoryConsumer;
import org.quartz.JobExecutionContext;
import org.quartz.impl.JobDetailImpl;

public class WCMCoreUtils {
    private static final Log LOG = ExoLogger.getLogger((String)WCMCoreUtils.class.getName());
    private static final String BAR_NAVIGATION_STYLE_KEY = "bar_navigation_style";

    public static <T> T getService(Class<T> clazz) {
        return WCMCoreUtils.getService(clazz, null);
    }

    public static SessionProvider getSystemSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }

    public static Node getNodeBySystemSession(Node node) throws RepositoryException {
        SessionProvider systemSessionProvider = WCMCoreUtils.getSystemSessionProvider();
        return (Node)systemSessionProvider.getSession(node.getSession().getWorkspace().getName(), WCMCoreUtils.getRepository()).getItem(node.getPath());
    }

    public static boolean canAccessParentNode(Node node) {
        try {
            node.getParent();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static SessionProvider getUserSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        return sessionProviderService.getSessionProvider(null);
    }

    public static boolean isAnonim() {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return userId == null;
    }

    public static SessionProvider createAnonimProvider() {
        return SessionProvider.createAnonimProvider();
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public static String getContainerNameFromJobContext(JobExecutionContext context) {
        return ((JobDetailImpl)context.getJobDetail()).getGroup().split(":")[0];
    }

    public static boolean hasPermission(String userId, List<String> permissions, boolean isNeedFullAccess) {
        block15: {
            if (userId == null || userId.length() == 0) {
                return false;
            }
            try {
                OrganizationService organizationService = WCMCoreUtils.getService(OrganizationService.class);
                WCMCoreUtils.startRequest(organizationService);
                Identity identity = ConversationState.getCurrent().getIdentity();
                LinkedList memberships = null;
                if (userId.equals(identity.getUserId())) {
                    Collection membershipsEntries = identity.getMemberships();
                    HashSet<MembershipImpl> membershipsHash = new HashSet<MembershipImpl>();
                    for (MembershipEntry membershipEntry : membershipsEntries) {
                        MembershipImpl m = new MembershipImpl();
                        m.setGroupId(membershipEntry.getGroup());
                        m.setMembershipType(membershipEntry.getMembershipType());
                        m.setUserName(userId);
                        membershipsHash.add(m);
                    }
                    memberships = new LinkedList(membershipsHash);
                } else {
                    memberships = organizationService.getMembershipHandler().findMembershipsByUser(userId);
                }
                int count = 0;
                String permissionTmp = "";
                for (String permission : permissions) {
                    if (!permissionTmp.equals(permission)) {
                        count = 0;
                    }
                    for (Object userMembershipObj : memberships) {
                        Membership userMembership = (Membership)userMembershipObj;
                        if (permission.equals(userMembership.getUserName())) {
                            return true;
                        }
                        if ("any".equals(permission)) {
                            if (isNeedFullAccess) {
                                if (++count != 4) continue;
                                return true;
                            }
                            return true;
                        }
                        if (permission.startsWith("*") && permission.contains(userMembership.getGroupId())) {
                            if (isNeedFullAccess) {
                                if (++count != 4) continue;
                                return true;
                            }
                            return true;
                        }
                        String userMembershipTmp = userMembership.getMembershipType() + ":" + userMembership.getGroupId();
                        if (!permission.equals(userMembershipTmp)) continue;
                        if (isNeedFullAccess) {
                            if (++count != 4) continue;
                            return true;
                        }
                        return true;
                    }
                    permissionTmp = permission;
                }
                WCMCoreUtils.endRequest(organizationService);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block15;
                LOG.error((Object)"hasPermission() failed because of ", (Throwable)e);
            }
        }
        return false;
    }

    public static <T> List<T> getAllElementsOfListAccess(ListAccess<T> listAccess) {
        try {
            return Arrays.asList(listAccess.load(0, listAccess.getSize()));
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"getAllElementsOfListAccess() failed because of ", (Throwable)e);
            }
            return null;
        }
    }

    public static ManageableRepository getRepository() {
        try {
            RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
            return repositoryService.getCurrentRepository();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"getRepository() failed because of ", (Throwable)e);
            }
            return null;
        }
    }

    public static void startRequest(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)orgService).startRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    public static void endRequest(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)orgService).endRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    public static String getRestContextName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return portalContainerConfig.getRestContextName(containerInfo.getContainerName());
    }

    public static String generateImageURI(Node file, String propertyName) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeLocation fileLocation = NodeLocation.getNodeLocationByNode(file);
        String repository = fileLocation.getRepository();
        String workspaceName = fileLocation.getWorkspace();
        String nodeIdentifiler = file.isNodeType("mix:referenceable") ? file.getUUID() : file.getPath().replaceFirst("/", "");
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (propertyName == null) {
            if (WCMCoreUtils.isNodeTypeOrFrozenType(file, "nt:file")) {
                InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
                if (stream.available() == 0) {
                    return null;
                }
                stream.close();
                builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?param=file");
                return builder.toString();
            }
            return null;
        }
        builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?param=").append(propertyName);
        return builder.toString();
    }

    public static boolean isNodeTypeOrFrozenType(Node node, String type) throws RepositoryException {
        if (node.isNodeType(type)) {
            return true;
        }
        if (!node.isNodeType("nt:frozenNode")) {
            return false;
        }
        String realType = node.getProperty("jcr:frozenPrimaryType").getString();
        return WCMCoreUtils.getRepository().getNodeTypeManager().getNodeType(realType).isNodeType(type);
    }

    public static String getPortalName() {
        PortalContainerInfo containerInfo = WCMCoreUtils.getService(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public static String getRemoteUser() {
        try {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public static String getSuperUser() {
        return WCMCoreUtils.getService(UserACL.class).getSuperUser();
    }

    public static boolean isDocumentNodeType(Node node) throws Exception {
        return node.isNodeType("nt:file");
    }

    public static String getBarNavigationStyle() {
        SettingService settingService = WCMCoreUtils.getService(SettingService.class);
        String barNavigationStyle = "Dark";
        SettingValue value = settingService.get(Context.GLOBAL, Scope.GLOBAL, BAR_NAVIGATION_STYLE_KEY);
        if (value != null) {
            barNavigationStyle = (String)value.getValue();
        } else {
            settingService.set(Context.GLOBAL, Scope.GLOBAL, BAR_NAVIGATION_STYLE_KEY, SettingValue.create((String)barNavigationStyle));
        }
        return barNavigationStyle;
    }

    public static String getLinkInDocumentsApplication(String nodePath) throws Exception {
        DocumentService documentService = WCMCoreUtils.getService(DocumentService.class);
        return documentService.getLinkInDocumentsApp(nodePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeUserSession(String userId, RepositoryConsumer<SessionProvider> handler) throws RepositoryException {
        IdentityRegistry identityRegistry = WCMCoreUtils.getService(IdentityRegistry.class);
        Identity userIdentity = identityRegistry.getIdentity(userId);
        if (userIdentity == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User identity not registered, trying to create it for: " + userId));
                }
                Authenticator authenticator = WCMCoreUtils.getService(Authenticator.class);
                userIdentity = authenticator.createIdentity(userId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to create user identity: " + userId), (Throwable)e);
                throw new IllegalArgumentException("User identity not found " + userId + " for setting conversation state");
            }
        }
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        ConversationState currentConvoState = ConversationState.getCurrent();
        SessionProvider currentContextProvider = sessionProviderService.getSessionProvider(null);
        try {
            ConversationState state = new ConversationState(userIdentity);
            state.setAttribute("subject", (Object)userIdentity.getSubject());
            ConversationState.setCurrent((ConversationState)state);
            SessionProvider userProvider = new SessionProvider(state);
            sessionProviderService.setSessionProvider(null, userProvider);
            handler.accept(userProvider);
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConvoState);
            sessionProviderService.setSessionProvider(null, currentContextProvider);
        }
    }

    private static class FileComparatorByPriority
    implements Comparator<Node> {
        private FileComparatorByPriority() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                if (!o1.hasProperty("exo:priority") && !o2.hasProperty("exo:priority")) {
                    return o1.getName().compareTo(o2.getName());
                }
                if (!o1.hasProperty("exo:priority")) {
                    return 1;
                }
                if (!o2.hasProperty("exo:priority")) {
                    return -1;
                }
                if (o1.getProperty("exo:priority").getLong() == o2.getProperty("exo:priority").getLong()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return (int)(o2.getProperty("exo:priority").getLong() - o1.getProperty("exo:priority").getLong());
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

