/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/contents/")
public class DownloadConnector
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)DownloadConnector.class.getName());

    @GET
    @Path(value="/download/{workspace}/{path:.*}")
    public Response download(@PathParam(value="workspace") String workspace, @PathParam(value="path") String path, @QueryParam(value="version") String version) throws Exception {
        InputStream is = null;
        String mimeType = "text/xml";
        Node node = null;
        String fileName = null;
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        try {
            path = URLDecoder.decode((String)path, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.debug((Object)"The filePath is already decoded");
        }
        try {
            node = (Node)session.getItem((String)path);
            fileName = node.getName();
            if (node.hasProperty("exo:title")) {
                fileName = node.getProperty("exo:title").getString();
            }
            try {
                fileName = URLDecoder.decode(fileName, "UTF-8");
            }
            catch (Exception e) {
                LOG.debug((Object)"The fileName is already decoded");
            }
            fileName = Text.unescapeIllegalJcrChars((String)fileName);
            fileName = URLEncoder.encode(fileName, "utf-8").replace("+", "%20");
            if (version != null) {
                node = node.getVersionHistory().getVersion(version).getNode("jcr:frozenNode");
            }
            Node jrcNode = node.getNode("jcr:content");
            is = jrcNode.getProperty("jcr:data").getStream();
        }
        catch (PathNotFoundException pne) {
            return Response.status((int)404).build();
        }
        catch (AccessDeniedException ade) {
            LOG.warn("You have not enough permissions on file: {}", new Object[]{fileName});
            return Response.status((int)404).build();
        }
        if (node.isNodeType("nt:file") || node.isNodeType("nt:frozenNode") && node.getProperty("jcr:frozenPrimaryType").getValue().getString().equals("nt:file")) {
            mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        return Response.ok((Object)is, (String)mimeType).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"; filename*=UTF-8''" + fileName)).build();
    }
}

