/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import javax.jcr.Node;
import org.exoplatform.ecm.connector.fckeditor.FCKFileHandler;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class DocumentLinkHandler
extends FCKFileHandler {
    private String baseURI;
    private String currentPortal;

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public String getFileURL(Node node) throws Exception {
        String accessMode = "private";
        AccessControlList acl = ((ExtendedNode)node).getACL();
        for (AccessControlEntry entry : acl.getPermissionEntries()) {
            if (!entry.getIdentity().equalsIgnoreCase(IdentityConstants.ANY) || !entry.getPermission().equalsIgnoreCase("read")) continue;
            accessMode = "public";
            break;
        }
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        String nodePath = node.getPath();
        StringBuilder builder = new StringBuilder();
        if (node.isNodeType("nt:file")) {
            if ("public".equals(accessMode)) {
                return builder.append(this.baseURI).append("/jcr/").append(repository).append("/").append(workspace).append(nodePath).toString();
            }
            return builder.append(this.baseURI).append("/private/jcr/").append(repository).append("/").append(workspace).append(nodePath).toString();
        }
        WCMConfigurationService configurationService = (WCMConfigurationService)WCMCoreUtils.getService(WCMConfigurationService.class);
        String parameterizedPageViewerURI = configurationService.getRuntimeContextParam("parameterizedPageURI");
        return this.baseURI.replace("/rest", "") + "/" + accessMode + "/" + this.currentPortal + parameterizedPageViewerURI + "/" + repository + "/" + workspace + nodePath;
    }

    public void setCurrentPortal(String currentPortal) {
        this.currentPortal = currentPortal;
    }

    public String getCurrentPortal() {
        return this.currentPortal;
    }
}

