/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives;

import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.services.cms.clouddrives.CloudDriveEvent;
import org.exoplatform.services.cms.clouddrives.CloudDriveListener;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CloudDriveDocumentsDriveInitializer
extends BaseComponentPlugin
implements CloudDriveListener {
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveDocumentsDriveInitializer.class);
    protected static final String DRIVE_VIEWS = "List, Icons, Admin";
    protected static final String DRIVE_ICON = "";
    protected static final boolean DRIVE_VIEW_REFERENCES = false;
    protected static final boolean DRIVE_VIEW_NON_DOCUMENT = false;
    protected static final boolean DRIVE_VIEW_SIDE_BAR = false;
    protected static final boolean DRIVE_SHOW_HIDDEN_NODE = false;
    protected static final String DRIVE_ALLOW_CREATE_FOLDER = "nt:folder,nt:unstructured";
    protected static final String DRIVE_ALLOW_NODE_TYPES_ON_TREE = "*";
    protected final ManageDriveService manageDriveService;

    public CloudDriveDocumentsDriveInitializer(ManageDriveService manageDriveService) {
        this.manageDriveService = manageDriveService;
    }

    protected void addDocumentDrive(CloudDriveEvent event) {
        try {
            this.manageDriveService.addDrive(event.getTitle(), event.getWorkspace(), event.getLocalUser(), event.getNodePath(), DRIVE_VIEWS, DRIVE_ICON, false, false, false, false, DRIVE_ALLOW_CREATE_FOLDER, DRIVE_ALLOW_NODE_TYPES_ON_TREE);
        }
        catch (Exception e) {
            LOG.warn((Object)("Warning adding a drive '" + event.getTitle() + "' by ManageDriveService"), (Throwable)e);
        }
    }

    protected void deleteDocumentDrive(CloudDriveEvent event) {
        try {
            this.manageDriveService.removeDrive(event.getTitle());
        }
        catch (Exception e) {
            LOG.warn((Object)("Warning removing a drive '" + event.getTitle() + "' by ManageDriveService"), (Throwable)e);
        }
    }

    @Override
    public void onRemove(CloudDriveEvent event) {
        this.deleteDocumentDrive(event);
    }

    @Override
    public void onCreate(CloudDriveEvent event) {
        this.addDocumentDrive(event);
    }
}

