/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.services.cms.documents.impl.DocumentType;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class DocumentTypeServiceImpl
implements DocumentTypeService,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)DocumentTypeServiceImpl.class.getName());
    private static final String OWNER = "exo:owner";
    private static final String QUERY = " SELECT * FROM nt:resource WHERE";
    private static final String CONTENT_QUERY = " SELECT * FROM nt:base WHERE ";
    private static final String EXO_DATE_MODIFIED = "exo:dateModified";
    private static final String JCR_MINE_TYPE = "jcr:mimeType";
    private static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    private static final String SQL = "sql";
    private static final String AND = " AND ";
    private static final String CONTAINS = " contains";
    private static final String SINGLE_QUOTE = "'";
    private static final String OR = " OR ";
    private static final String BEGIN_BRANCH = " ( ";
    private static final String END_BRANCH = " ) ";
    private RepositoryService repositoryService_;
    private InitParams params_;
    private static final String OPEN_DESKTOP_PROVIDER_REGEX = "^exo.remote-edit\\.([a-z]+)$";
    private static final String OPEN_PROVIDER_RESOURCEBUNDLE_SUFFIX = ".label";
    private static final String OPEN_PROVIDER_STYLE_SUFFIX = ".ico";
    private final String OPEN_DOCUMENT_ON_DESKTOP_ICO = "uiIconOpenOnDesktop";
    private final String OPEN_DOCUMENT_IN_DESKTOP_RESOURCE_KEY = "OpenInOfficeConnector.label.exo.remote-edit.desktop";

    private void init() {
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.matches(OPEN_DESKTOP_PROVIDER_REGEX)) continue;
            List<String> _mimetypes = Arrays.asList(properties.getProperty(key) != null ? properties.getProperty(key).split(",") : null);
            String _resourceBundle = properties.getProperty(key + OPEN_PROVIDER_RESOURCEBUNDLE_SUFFIX);
            String _ico = properties.getProperty(key + OPEN_PROVIDER_STYLE_SUFFIX);
            if (this.params_.get((Object)key) != null) {
                this.params_.remove((Object)key);
            }
            ObjectParameter _objectParameter = new ObjectParameter();
            _objectParameter.setName(key);
            _objectParameter.setObject((Object)new DocumentType(_mimetypes, _resourceBundle, _ico));
            this.params_.addParam((Object)_objectParameter);
        }
    }

    public DocumentTypeServiceImpl(RepositoryService repoService, InitParams initParams) {
        this.repositoryService_ = repoService;
        this.params_ = initParams;
    }

    @Override
    public List<String> getAllSupportedType() {
        ArrayList<String> supportedType = new ArrayList<String>();
        Iterator iter = this.params_.getObjectParamIterator();
        ObjectParameter objectParam = null;
        while (iter.hasNext()) {
            objectParam = (ObjectParameter)iter.next();
            if (!Boolean.parseBoolean(((DocumentType)objectParam.getObject()).getDisplayInFilter())) continue;
            supportedType.add(objectParam.getName());
        }
        Collections.sort(supportedType);
        return supportedType;
    }

    @Override
    public List<Node> getAllDocumentsByDocumentType(String documentType, String workspace, SessionProvider sessionProvider) throws Exception {
        return this.getAllDocumentsByType(workspace, sessionProvider, this.getMimeTypes(documentType));
    }

    @Override
    public List<Node> getAllDocumentsByType(String workspace, SessionProvider sessionProvider, String mimeType) throws Exception {
        return this.getAllDocumentsByType(workspace, sessionProvider, new String[]{mimeType});
    }

    @Override
    public List<Node> getAllDocumentsByUser(String workspace, SessionProvider sessionProvider, String[] mimeTypes, String userName) throws Exception {
        Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
        ArrayList<Node> resultList = new ArrayList<Node>();
        QueryResult results = null;
        results = this.executeQuery(session, this.buildQueryByMimeTypes(mimeTypes, userName), SQL);
        NodeIterator iterator = results.getNodes();
        Node documentNode = null;
        while (iterator.hasNext()) {
            documentNode = iterator.nextNode();
            resultList.add(documentNode.getParent());
        }
        return resultList;
    }

    @Override
    public List<Node> getAllDocumentsByType(String workspace, SessionProvider sessionProvider, String[] mimeTypes) throws Exception {
        return this.getAllDocumentsByUser(workspace, sessionProvider, mimeTypes, null);
    }

    @Override
    public String[] getMimeTypes(String documentType) {
        Iterator iter = this.params_.getObjectParamIterator();
        ObjectParameter objectParam = null;
        List<Object> mimeTypes = new ArrayList();
        while (iter.hasNext()) {
            objectParam = (ObjectParameter)iter.next();
            if (!objectParam.getName().equals(documentType)) continue;
            mimeTypes = ((DocumentType)objectParam.getObject()).getMimeTypes();
            break;
        }
        return mimeTypes.toArray(new String[mimeTypes.size()]);
    }

    @Override
    public boolean isContentsType(String documentType) {
        Iterator iter = this.params_.getObjectParamIterator();
        ObjectParameter objectParam = null;
        while (iter.hasNext()) {
            objectParam = (ObjectParameter)iter.next();
            if (!objectParam.getName().equals(documentType)) continue;
            return Boolean.parseBoolean(((DocumentType)objectParam.getObject()).getContentsType());
        }
        return false;
    }

    @Override
    public List<Node> getAllDocumentByContentsType(String documentType, String workspace, SessionProvider sessionProvider, String userName) throws Exception {
        if (this.isContentsType(documentType)) {
            QueryResult results;
            ArrayList<Node> resultList;
            block6: {
                Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
                resultList = new ArrayList<Node>();
                results = null;
                try {
                    results = this.executeQuery(session, this.buildQueryByContentsType(userName), SQL);
                }
                catch (PathNotFoundException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"An unexpected exception appear", (Throwable)e);
                    }
                }
                catch (RepositoryException e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error((Object)"An unexpected exception appear", (Throwable)e);
                }
            }
            NodeIterator iterator = results.getNodes();
            while (iterator.hasNext()) {
                resultList.add(iterator.nextNode());
            }
            return resultList;
        }
        return null;
    }

    private QueryResult executeQuery(Session session, String statement, String language) {
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(statement, language);
            return query.execute();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"SQL query fail", (Throwable)e);
            }
            return null;
        }
    }

    private String buildQueryByMimeTypes(String[] mimeTypes, String userName) {
        StringBuilder query = new StringBuilder();
        if (userName == null) {
            for (String mimeType : mimeTypes) {
                if (query.length() > 0) {
                    query.append(OR);
                }
                query.append(CONTAINS).append("(").append(JCR_MINE_TYPE).append(",").append(SINGLE_QUOTE).append(mimeType.trim()).append(SINGLE_QUOTE).append(")");
            }
        } else {
            query.append(BEGIN_BRANCH);
            for (String mimeType : mimeTypes) {
                if (query.length() > BEGIN_BRANCH.length()) {
                    query.append(OR);
                }
                query.append(CONTAINS).append("(").append(JCR_MINE_TYPE).append(",").append(SINGLE_QUOTE).append(mimeType.trim()).append(SINGLE_QUOTE).append(")");
            }
            query.append(END_BRANCH);
            query.append(AND);
            query.append("(").append(OWNER).append("=").append(SINGLE_QUOTE).append(userName).append(SINGLE_QUOTE).append(")");
        }
        query.append(" ORDER  BY exo:dateModified");
        return QUERY + query.toString();
    }

    private String buildQueryByContentsType(String userName) throws PathNotFoundException, RepositoryException {
        List<String> contentsType = Collections.singletonList("nt:file");
        StringBuilder constraint = new StringBuilder();
        if (userName == null) {
            for (String contentType : contentsType) {
                if (constraint.length() > 0) {
                    constraint.append(OR);
                }
                constraint.append("(").append(JCR_PRIMARY_TYPE).append("=").append(SINGLE_QUOTE).append(contentType).append(SINGLE_QUOTE).append(")");
            }
        } else {
            constraint.append(BEGIN_BRANCH);
            for (String contentType : contentsType) {
                if (constraint.length() > BEGIN_BRANCH.length()) {
                    constraint.append(OR);
                }
                constraint.append("(").append(JCR_PRIMARY_TYPE).append("=").append(SINGLE_QUOTE).append(contentType).append(SINGLE_QUOTE).append(")");
            }
            constraint.append(END_BRANCH);
            constraint.append(AND);
            constraint.append("(").append(OWNER).append("=").append(SINGLE_QUOTE).append(userName).append(SINGLE_QUOTE).append(")");
        }
        constraint.append(" ORDER  BY exo:dateModified");
        return CONTENT_QUERY + constraint.toString();
    }

    @Override
    public DocumentType getDocumentType(String mimeType) {
        DocumentType documentTypeResult = null;
        for (DocumentType documentType : this.params_.getObjectParamValues(DocumentType.class)) {
            if (!documentType.getMimeTypes().contains(mimeType)) continue;
            documentTypeResult = documentType;
        }
        if (documentTypeResult == null) {
            documentTypeResult = new DocumentType(Arrays.asList(mimeType), "OpenInOfficeConnector.label.exo.remote-edit.desktop", "uiIconOpenOnDesktop");
        }
        return documentTypeResult;
    }

    public void start() {
        this.init();
    }

    public void stop() {
    }
}

