/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.util.Library;

public class BorderStyle
extends Dictionary {
    private static final float[] DEFAULT_DASH_ARRAY = new float[]{3.0f};
    public static final Name BORDER_STYLE_KEY = new Name("S");
    public static final Name BORDER_WIDTH_KEY = new Name("W");
    public static final Name BORDER_DASH_KEY = new Name("D");
    public static final Color DARKEST = Color.black;
    public static final Color DARK = new Color(-10461088);
    public static final Color LIGHT = new Color(-7303024);
    public static final Color LIGHTEST = new Color(-1710619);
    public static final Name BORDER_STYLE_SOLID = new Name("S");
    public static final Name BORDER_STYLE_DASHED = new Name("D");
    public static final Name BORDER_STYLE_BEVELED = new Name("B");
    public static final Name BORDER_STYLE_INSET = new Name("I");
    public static final Name BORDER_STYLE_UNDERLINE = new Name("U");
    private float strokeWidth = 1.0f;
    private Name borderStyle;
    private float[] dashArray = DEFAULT_DASH_ARRAY;

    public BorderStyle(Library l, HashMap h) {
        super(l, h);
        List dashVector;
        Object style;
        Number value = (Number)this.getObject(BORDER_WIDTH_KEY);
        if (value != null) {
            this.strokeWidth = value.floatValue();
        }
        if ((style = this.getObject(BORDER_STYLE_KEY)) != null) {
            this.borderStyle = (Name)style;
        }
        if ((dashVector = (List)this.getObject(BORDER_STYLE_DASHED)) != null) {
            int sz = dashVector.size();
            float[] dashArray = new float[sz];
            for (int i = 0; i < sz; ++i) {
                Number num = (Number)dashVector.get(i);
                dashArray[i] = num.floatValue();
            }
            this.dashArray = dashArray;
        }
    }

    public BorderStyle() {
        super(null, null);
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public Name getBorderStyle() {
        return this.borderStyle;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.entries.put(BORDER_WIDTH_KEY, Float.valueOf(this.strokeWidth));
    }

    public void setBorderStyle(Name lineStyle) {
        this.borderStyle = lineStyle;
        this.entries.put(BORDER_STYLE_KEY, this.borderStyle);
        if (this.borderStyle.equals(BORDER_STYLE_DASHED)) {
            this.entries.put(BORDER_DASH_KEY, Arrays.asList(Float.valueOf(3.0f)));
        } else {
            this.entries.remove(BORDER_DASH_KEY);
        }
    }

    public boolean isStyleSolid() {
        return BORDER_STYLE_SOLID.equals(this.borderStyle);
    }

    public boolean isStyleDashed() {
        return BORDER_STYLE_DASHED.equals(this.borderStyle);
    }

    public boolean isStyleBeveled() {
        return BORDER_STYLE_BEVELED.equals(this.borderStyle);
    }

    public boolean isStyleInset() {
        return BORDER_STYLE_INSET.equals(this.borderStyle);
    }

    public boolean isStyleUnderline() {
        return BORDER_STYLE_UNDERLINE.equals(this.borderStyle);
    }

    public void setDashArray(float[] dashArray) {
        if (dashArray != null) {
            this.dashArray = dashArray;
            int sz = dashArray.length;
            ArrayList<Float> dashVector = new ArrayList<Float>(sz);
            for (int i = 0; i < sz; ++i) {
                dashVector.add(Float.valueOf(dashArray[i]));
            }
            this.dashArray = dashArray;
            this.entries.put(BORDER_STYLE_DASHED, dashVector);
        }
    }

    public float[] getDashArray() {
        return this.dashArray;
    }
}

