/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecms.legacy.search.data.SearchResult;
import org.exoplatform.ecms.legacy.search.es.ElasticSearchFilter;
import org.exoplatform.ecms.legacy.search.es.ElasticSearchFilterType;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.connector.FileSearchServiceConnector;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="search/documents")
@Tag(name="search/documents", description="Managing search documents")
public class FileSearchRestService
implements ResourceContainer {
    private FileSearchServiceConnector fileSearchServiceConnector;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private static final int DEFAULT_LIMIT = 20;

    public FileSearchRestService(FileSearchServiceConnector fileSearchServiceConnector, NodeHierarchyCreator nodeHierarchyCreator) {
        this.fileSearchServiceConnector = fileSearchServiceConnector;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    @GET
    @Path(value="/recent")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets recent documents", method="GET", description="This returns recent documents")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response searchRecentDocuments(@Parameter(description="Query string") @QueryParam(value="q") String query, @Parameter(description="My work") @Schema(defaultValue="false") @QueryParam(value="myWork") boolean myWork, @Parameter(description="Sort field") @QueryParam(value="sortField") String sortField, @Parameter(description="Sort direction") @QueryParam(value="sortDirection") String sortDirection, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="favorites") @Schema(defaultValue="false") @QueryParam(value="favorites") boolean favorites, @Parameter(description="Tag names list") @Schema(defaultValue="false") @QueryParam(value="tags") List<String> tagNames, @Parameter(description="Space id") @QueryParam(value="spaceId") List<Long> spaceIds) throws Exception {
        StringBuilder recentFilter;
        if (limit <= 0) {
            limit = 20;
        }
        ArrayList<ElasticSearchFilter> recentFilters = new ArrayList<ElasticSearchFilter>();
        String userid = String.valueOf(RestUtils.getCurrentUserIdentityId());
        if (myWork) {
            recentFilters.add(this.filterMyWorkingDocuments());
        }
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (favorites) {
            recentFilter = new StringBuilder();
            metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(userid));
            String favoriteQuery = this.buildFavoriteQueryStatement((List)metadataFilters.get(FavoriteService.METADATA_TYPE.getName()));
            recentFilter.append(favoriteQuery);
            recentFilters.add(new ElasticSearchFilter(ElasticSearchFilterType.FILTER_MATADATAS, "", recentFilter.toString()));
        }
        if (CollectionUtils.isNotEmpty(spaceIds)) {
            List<String> spaceIdsString = spaceIds.stream().map(String::valueOf).toList();
            recentFilters.add(new ElasticSearchFilter(ElasticSearchFilterType.FILTER_BY_SPACE, "", StringUtils.join(spaceIdsString, (String)",")));
        }
        if (!CollectionUtils.isEmpty(tagNames)) {
            recentFilter = new StringBuilder();
            metadataFilters.put(TagService.METADATA_TYPE.getName(), tagNames);
            String tagsQuery = this.buildTagsQueryStatement((List)metadataFilters.get(TagService.METADATA_TYPE.getName()));
            recentFilter.append(tagsQuery);
            recentFilters.add(new ElasticSearchFilter(ElasticSearchFilterType.FILTER_MATADATAS, "", recentFilter.toString()));
        }
        recentFilters.add(this.getFileTypesFilter(myWork));
        UserACL userACL = (UserACL)PortalContainer.getInstance().getComponentInstanceOfType(UserACL.class);
        if (!userACL.isSuperUser(ConversationState.getCurrent().getIdentity()) && !userACL.isUserInGroup(ConversationState.getCurrent().getIdentity(), userACL.getAdminGroups())) {
            recentFilters.add(this.getPathsFilter(Arrays.asList("/Groups/spaces", this.getUserPrivateNode().getPath())));
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            query = query.replace("#", " ").replace("$", " ").replace("_", " ").replace(".", " ");
        }
        Collection<SearchResult> recentDocuments = this.fileSearchServiceConnector.filteredSearch(null, query, recentFilters, null, 0, limit, sortField, sortDirection);
        return Response.ok(recentDocuments).build();
    }

    @GET
    @Path(value="/recentSpaces")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets recent spaces documents", method="GET", description="This returns recent spaces documents")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response searchRecentSpacesDocuments(@Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (limit <= 0) {
            limit = 20;
        }
        ArrayList<ElasticSearchFilter> recentSpacesFilters = new ArrayList<ElasticSearchFilter>();
        recentSpacesFilters.add(this.getFileTypesFilter());
        recentSpacesFilters.add(this.getPathsFilter(Arrays.asList("/Groups/spaces")));
        Collection<SearchResult> recentSpacesDocuments = this.fileSearchServiceConnector.filteredSearch(null, null, recentSpacesFilters, null, 0, limit, "date", "desc");
        return Response.ok(recentSpacesDocuments).build();
    }

    private ElasticSearchFilter getFileTypesFilter(boolean myWork) {
        StringBuilder fileTypesFilter = new StringBuilder();
        fileTypesFilter.append("{\n \"term\" : { \"fileType\" : \"application/pdf\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.ms-excel\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"text/plain\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/rtf\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.openxmlformats-officedocument.presentationml.presentation\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.ms-powerpoint\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.oasis.opendocument.text\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/msword\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.openxmlformats-officedocument.wordprocessingml.document\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.openxmlformats-officedocument.wordprocessingml.document.form\" }\n }");
        if (!myWork) {
            fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"image/jpeg\" }\n }");
            fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"image/png\" }\n }");
            fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"image/gif\" }\n }");
        }
        return new ElasticSearchFilter(ElasticSearchFilterType.FILTER_CUSTOM, "fileType", fileTypesFilter.toString());
    }

    private ElasticSearchFilter getFileTypesFilter() {
        return this.getFileTypesFilter(false);
    }

    private ElasticSearchFilter getPathsFilter(List<String> paths) {
        StringBuilder pathsFilter = new StringBuilder();
        int count = 0;
        for (String path : paths) {
            pathsFilter.append("{\n \"regexp\" : { \"path\" : \"" + path + ".*\" }\n }");
            if (++count >= paths.size()) continue;
            pathsFilter.append(",");
        }
        return new ElasticSearchFilter(ElasticSearchFilterType.FILTER_CUSTOM, "path", pathsFilter.toString());
    }

    private ElasticSearchFilter filterMyWorkingDocuments() {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        StringBuilder recentFilter = new StringBuilder();
        recentFilter.append("\"should\" :[\n{\n \"term\" : { \"author\" : \"" + userId + "\" }\n },{\n \"term\" : { \"lastModifier\" : \"" + userId + "\" }\n }\n]");
        return new ElasticSearchFilter(ElasticSearchFilterType.FILTER_MY_WORK_DOCS, "", recentFilter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getUserPrivateNode() throws Exception {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Node userNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, userId);
            Node node = userNode.getNode("Private");
            return node;
        }
    }

    private String buildFavoriteQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        return "{\"terms\":{" + "\"metadatas.favorites.metadataName.keyword\": [\"" + StringUtils.join(values, (String)"\",\"") + "\"]}},";
    }

    private String buildTagsQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        List tagsQueryParts = values.stream().map(value -> "{\"term\": {\n" + "            \"metadatas.tags.metadataName.keyword\": {\n" + "              \"value\": \"" + value + "\",\n" + "              \"case_insensitive\":true\n" + "            }\n" + "          }}").collect(Collectors.toList());
        return StringUtils.join(tagsQueryParts, (String)",") + "  ,\n";
    }
}

