/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.listeners;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ChangeStatusUserListener
extends UserEventListener {
    public void postSetEnabled(User user) throws Exception {
        super.postSetEnabled(user);
        NodeHierarchyCreator nodeHierarchy = WCMCoreUtils.getService(NodeHierarchyCreator.class);
        Node userNode = nodeHierarchy.getUserNode(WCMCoreUtils.getSystemSessionProvider(), user.getUserName());
        if (user.isEnabled()) {
            if (userNode.isNodeType("exo:privilegeable")) {
                HashMap<String, String[]> permissions = new HashMap<String, String[]>();
                List aces = ((ExtendedNode)userNode.getParent()).getACL().getPermissionEntries();
                for (AccessControlEntry entry : aces) {
                    if (permissions.containsKey(entry.getIdentity())) {
                        String[] perms = (String[])permissions.get(entry.getIdentity());
                        String[] newPerms = new String[perms.length + 1];
                        System.arraycopy(perms, 0, newPerms, 0, perms.length);
                        newPerms[perms.length] = entry.getPermission();
                        permissions.put(entry.getIdentity(), newPerms);
                        continue;
                    }
                    permissions.put(entry.getIdentity(), new String[]{entry.getPermission()});
                }
                ((ExtendedNode)userNode).setPermissions(permissions);
                userNode.save();
                userNode.removeMixin("exo:privilegeable");
                userNode.save();
            }
        } else if (userNode.canAddMixin("exo:privilegeable")) {
            userNode.addMixin("exo:privilegeable");
            HashMap<String, String[]> permissions = new HashMap<String, String[]>();
            permissions.put(IdentityConstants.SYSTEM, PermissionType.ALL);
            ((ExtendedNode)userNode).setPermissions(permissions);
            userNode.save();
        }
    }
}

