/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecms.legacy.search.data.SearchContext;
import org.exoplatform.ecms.legacy.search.data.SearchResult;
import org.exoplatform.ecms.legacy.search.es.ElasticSearchFilter;
import org.exoplatform.ecms.legacy.search.es.ElasticSearchFilterType;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.connector.FileSearchServiceConnector;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.router.Router;

public class FileApplicationSearchServiceConnector
extends FileSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger((String)FileApplicationSearchServiceConnector.class.getName());
    private String filteredWorkspace;
    private String filteredPath;

    public FileApplicationSearchServiceConnector(InitParams initParams, ElasticSearchingClient client, RepositoryService repositoryService, DocumentService documentService) {
        super(initParams, client, repositoryService, documentService);
    }

    public Collection<SearchResult> appSearch(String workspace, String path, Locale locale, String query, int offset, int limit, String sort, String order) {
        this.filteredWorkspace = workspace;
        this.filteredPath = path;
        if (StringUtils.isNotEmpty((CharSequence)this.filteredPath) && !this.filteredPath.endsWith("/")) {
            this.filteredPath = this.filteredPath + "/";
        }
        try {
            SearchContext context = new SearchContext(new Router(new ControllerDescriptor()), "");
            locale = locale != null ? locale : Locale.ENGLISH;
            context.lang(locale.toString());
            return super.search(context, query, null, offset, limit, sort, order);
        }
        catch (Exception ex) {
            LOG.error((Object)"Can not create SearchContext", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    protected String getAdditionalFilters(List<ElasticSearchFilter> filters) {
        if (StringUtils.isNotEmpty((CharSequence)this.filteredWorkspace)) {
            filters = this.addFilter(filters, new ElasticSearchFilter(ElasticSearchFilterType.FILTER_BY_TERM, "workspace", this.filteredWorkspace));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.filteredPath)) {
            filters = this.addFilter(filters, new ElasticSearchFilter(ElasticSearchFilterType.FILTER_CUSTOM, "", "{ \"prefix\" : { \"path\" :  { \"value\" : \"" + this.filteredPath + "\" } } }"));
        }
        return super.getAdditionalFilters(filters);
    }

    private List<ElasticSearchFilter> addFilter(List<ElasticSearchFilter> filters, ElasticSearchFilter elasticSearchFilter) {
        if (filters == null) {
            filters = new ArrayList<ElasticSearchFilter>();
        }
        filters.add(elasticSearchFilter);
        return filters;
    }
}

