/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.jcr;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.clouddrives.LocalCloudFile;

public class JCRLocalCloudFile
extends LocalCloudFile {
    public static final long FOLDER_SIZE = -1L;
    private final String path;
    private final String id;
    private final String title;
    private final String link;
    private final String editLink;
    private final String previewLink;
    private final String thumbnailLink;
    private final String type;
    private final String typeMode;
    private final String lastUser;
    private final String author;
    private final boolean folder;
    private final long size;
    private final transient Calendar createdDate;
    private final transient Calendar modifiedDate;
    private final transient Calendar localModifiedDate;
    private final transient Node node;
    private final transient boolean changed;

    protected JCRLocalCloudFile(String path, String id, String title, String link, String editLink, String previewLink, String thumbnailLink, String type, String typeMode, String lastUser, String author, Calendar createdDate, Calendar modifiedDate, boolean folder, long size, Node node, boolean changed) {
        Calendar localModifiedDate;
        this.path = path;
        this.id = id;
        this.title = title;
        this.link = link;
        this.editLink = editLink;
        this.previewLink = previewLink;
        this.thumbnailLink = thumbnailLink;
        this.type = type;
        this.typeMode = typeMode;
        this.lastUser = lastUser;
        this.author = author;
        this.createdDate = createdDate;
        this.modifiedDate = modifiedDate;
        this.folder = folder;
        this.size = size;
        this.node = node;
        this.changed = changed;
        try {
            localModifiedDate = node.getProperty("exo:lastModifiedDate").getDate();
        }
        catch (NullPointerException | RepositoryException e) {
            LOG.debug("Cannot read local modified date of cloud file {}", new Object[]{path, e});
            localModifiedDate = this.modifiedDate;
        }
        this.localModifiedDate = localModifiedDate;
    }

    public JCRLocalCloudFile(String path, String id, String title, String link, String editLink, String previewLink, String thumbnailLink, String type, String typeMode, String lastUser, String author, Calendar createdDate, Calendar modifiedDate, long size, Node node, boolean changed) {
        this(path, id, title, link, editLink, previewLink, thumbnailLink, type, typeMode, lastUser, author, createdDate, modifiedDate, false, size, node, changed);
    }

    public JCRLocalCloudFile(String path, String id, String title, String link, String previewLink, String thumbnailLink, String type, String typeMode, String lastUser, String author, Calendar createdDate, Calendar modifiedDate, long size, Node node, boolean changed) {
        this(path, id, title, link, null, previewLink, thumbnailLink, type, typeMode, lastUser, author, createdDate, modifiedDate, false, size, node, changed);
    }

    public JCRLocalCloudFile(String path, String id, String title, String link, String type, String lastUser, String author, Calendar createdDate, Calendar modifiedDate, Node node, boolean changed) {
        this(path, id, title, link, null, null, null, type, null, lastUser, author, createdDate, modifiedDate, true, -1L, node, changed);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public String getEditLink() {
        return this.editLink;
    }

    @Override
    public String getPreviewLink() {
        return this.previewLink;
    }

    @Override
    public String getThumbnailLink() {
        return this.thumbnailLink;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypeMode() {
        return this.typeMode;
    }

    @Override
    public String getLastUser() {
        return this.lastUser;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Calendar getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public Calendar getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public boolean isFolder() {
        return this.folder;
    }

    @Override
    public long getSize() {
        return this.isFolder() ? -1L : this.size;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public Calendar getLocalModifiedDate() {
        return this.localModifiedDate;
    }
}

