/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.CloudFileAPI;
import org.exoplatform.services.cms.clouddrives.CloudFileSynchronizer;
import org.exoplatform.services.cms.clouddrives.SkipSyncException;
import org.exoplatform.services.cms.clouddrives.SyncNotSupportedException;
import org.exoplatform.services.cms.clouddrives.jcr.JCRLocalCloudDrive;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NtFileSynchronizer
implements CloudFileSynchronizer {
    public static final String[] NODETYPES = new String[]{"nt:file", "nt:folder"};
    protected static final Log LOG = ExoLogger.getLogger(NtFileSynchronizer.class);

    @Override
    public String[] getSupportedNodetypes() {
        return NODETYPES;
    }

    @Override
    public boolean accept(Node file) throws RepositoryException, SkipSyncException {
        if (file.isNodeType("nt:file") || file.isNodeType("nt:folder")) {
            return true;
        }
        if (file.isNodeType("nt:resource")) {
            throw new SkipSyncException("Skip synchronization of nt:resource");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudFile create(Node file, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        CloudFile result;
        String title;
        try {
            title = api.getTitle(file);
        }
        catch (PathNotFoundException e) {
            try {
                title = file.getProperty("exo:name").getString();
            }
            catch (PathNotFoundException e1) {
                title = file.getName();
            }
        }
        Calendar created = file.getProperty("jcr:created").getDate();
        if (file.isNodeType("nt:file")) {
            Node resource = file.getNode("jcr:content");
            String mimeType = resource.getProperty("jcr:mimeType").getString();
            Calendar modified = resource.getProperty("jcr:lastModified").getDate();
            InputStream data = resource.getProperty("jcr:data").getStream();
            try {
                result = api.createFile(file, created, modified, mimeType, data);
                resource.setProperty("jcr:data", JCRLocalCloudDrive.DUMMY_DATA);
            }
            finally {
                try {
                    data.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error closing content stream of cloud file " + title + ": " + e.getMessage()));
                }
            }
        }
        if (file.isNodeType("nt:folder")) {
            result = api.createFolder(file, created);
            NodeIterator childs = file.getNodes();
            while (childs.hasNext()) {
                this.create(childs.nextNode(), api);
            }
        } else {
            throw new SyncNotSupportedException("Unexpected type of created node in nt:file or nt:folder hierarchy: " + file.getPrimaryNodeType().getName() + ". Location: " + file.getPath());
        }
        return result;
    }

    @Override
    public boolean remove(String filePath, String fileId, boolean isFolder, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        if (isFolder) {
            return api.removeFolder(fileId);
        }
        return api.removeFile(fileId);
    }

    @Override
    public boolean trash(String filePath, String fileId, boolean isFolder, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        if (isFolder) {
            return api.trashFolder(fileId);
        }
        return api.trashFile(fileId);
    }

    @Override
    public CloudFile untrash(Node file, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        if (api.isFolder(file)) {
            return api.untrashFolder(file);
        }
        return api.untrashFile(file);
    }

    @Override
    public CloudFile update(Node file, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        if (api.isFolder(file)) {
            Calendar modified = file.isNodeType("exo:datetime") ? file.getProperty("exo:dateModified").getDate() : Calendar.getInstance();
            return api.updateFolder(file, modified);
        }
        if (api.isFile(file)) {
            Node resource = file.getNode("jcr:content");
            Calendar modified = resource.getProperty("jcr:lastModified").getDate();
            return api.updateFile(file, modified);
        }
        throw new SyncNotSupportedException("Unexpected type of updated node in nt:file or nt:folder hierarchy: " + file.getPrimaryNodeType().getName() + ". Location: " + file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudFile updateContent(Node file, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        String title = api.getTitle(file);
        if (api.isFile(file)) {
            Node resource = file.getNode("jcr:content");
            String mimeType = resource.getProperty("jcr:mimeType").getString();
            Calendar modified = resource.getProperty("jcr:lastModified").getDate();
            InputStream data = resource.getProperty("jcr:data").getStream();
            try {
                CloudFile cloudFile = api.updateFileContent(file, modified, mimeType, data);
                return cloudFile;
            }
            finally {
                try {
                    data.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error closing content stream of cloud file " + title + ": " + e.getMessage()));
                }
            }
        }
        throw new SyncNotSupportedException("Unexpected type of updated node (content) in nt:file or nt:folder hierarchy: " + file.getPrimaryNodeType().getName() + ". Location: " + file.getPath());
    }

    @Override
    public CloudFile copy(Node srcFile, Node destFile, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        if (api.isFolder(destFile)) {
            return api.copyFolder(srcFile, destFile);
        }
        if (api.isFile(destFile)) {
            return api.copyFile(srcFile, destFile);
        }
        throw new SyncNotSupportedException("Unexpected type of copied node in nt:file or nt:folder hierarchy: " + destFile.getPrimaryNodeType().getName() + ". Location: " + destFile.getPath());
    }
}

