/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.oauth2;

import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.oauth2.UserTokenRefreshListener;

public abstract class UserToken {
    private String accessToken;
    private String refreshToken;
    private Long expirationTime;
    private Set<UserTokenRefreshListener> listeners = new LinkedHashSet<UserTokenRefreshListener>();

    protected UserToken() {
    }

    public void addListener(UserTokenRefreshListener listener) throws CloudDriveException {
        this.listeners.add(listener);
        listener.onUserTokenRefresh(this);
    }

    public void removeListener(UserTokenRefreshListener listener) {
        this.listeners.remove(listener);
    }

    public void load(String accessToken, String refreshToken, Long expirationTime) throws CloudDriveException {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expirationTime = expirationTime;
    }

    public void store(String accessToken, String refreshToken, Long expirationTime) throws CloudDriveException {
        this.load(accessToken, refreshToken, expirationTime);
        this.fireListenersRefresh();
    }

    public void clear() throws CloudDriveException {
        this.load(null, null, null);
        this.fireListenersRemove();
    }

    public void merge(UserToken newToken) throws CloudDriveException {
        newToken.removeListeners();
        this.store(newToken.getAccessToken(), newToken.getRefreshToken(), newToken.getExpirationTime());
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    void unregisterListeners() {
        this.listeners.clear();
    }

    void removeListeners() throws CloudDriveException {
        this.listeners.clear();
    }

    private void fireListenersRefresh() throws CloudDriveException {
        for (UserTokenRefreshListener listener : this.listeners) {
            listener.onUserTokenRefresh(this);
        }
    }

    private void fireListenersRemove() throws CloudDriveException {
        for (UserTokenRefreshListener listener : this.listeners) {
            listener.onUserTokenRemove();
        }
    }
}

