/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.jcr;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveManager;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.SyncNotSupportedException;
import org.exoplatform.services.cms.clouddrives.jcr.AbstractJCRAction;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RemoveCloudFileAction
extends AbstractJCRAction {
    private static Log LOG = ExoLogger.getLogger(RemoveCloudFileAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(Context context) throws Exception {
        Node fileNode = (Node)context.get((Object)InvocationContext.CURRENT_ITEM);
        if (2 == (Integer)context.get((Object)InvocationContext.EVENT)) {
            CloudDriveService drives = this.getComponent(context, CloudDriveService.class);
            CloudDrive localDrive = drives.findDrive(fileNode);
            if (localDrive == null) return false;
            if (!this.accept(localDrive)) return true;
            if (localDrive.isConnected()) {
                try {
                    this.start(localDrive);
                    try {
                        new CloudDriveManager(localDrive).initRemove(fileNode);
                        return true;
                    }
                    catch (SyncNotSupportedException e) {
                        LOG.error((Object)("Cannor remove cloud drive file " + fileNode.getPath() + ": " + e.getMessage()));
                    }
                    return true;
                }
                finally {
                    this.done();
                }
            }
            try {
                Node driveParent = fileNode.getSession().getItem(localDrive.getPath()).getParent();
                if (driveParent.isNodeType("exo:trashFolder")) {
                    return true;
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            LOG.warn((Object)("Cloud drive not connected " + localDrive.getPath()));
            return false;
        }
        LOG.warn((Object)(RemoveCloudFileAction.class.getName() + " supports only node removal. Check configuration. Item skipped: " + fileNode.getPath()));
        return false;
    }
}

