/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.customization;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceCustomizationService {
    private static final String GROUPS_PATH = "groupsPath";
    private static final String ACTIVITY_FOLDER_UPLOAD_NAME = "Activity Stream Documents";
    private SessionProviderService sessionProviderService;
    private NodeHierarchyCreator nodeHierarchyCreator = null;
    private RepositoryService repositoryService = null;
    private SpaceService spaceService = null;
    private String groupsPath;

    public SpaceCustomizationService(SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.groupsPath = nodeHierarchyCreator.getJcrPath(GROUPS_PATH);
        if (StringUtils.isNotBlank((CharSequence)this.groupsPath) && this.groupsPath.lastIndexOf("/") == this.groupsPath.length() - 1) {
            this.groupsPath = this.groupsPath.substring(0, this.groupsPath.lastIndexOf("/"));
        }
    }

    public void createSpaceDefaultFolders(String groupId) throws Exception {
        String groupPath;
        String spaceParentPath;
        ManageableRepository currentRepository;
        String workspaceName;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(workspaceName = (currentRepository = this.repositoryService.getCurrentRepository()).getConfiguration().getDefaultWorkspaceName(), currentRepository);
        if (!session.itemExists(spaceParentPath = (groupPath = this.nodeHierarchyCreator.getJcrPath(GROUPS_PATH)) + groupId + "/Documents")) {
            throw new IllegalStateException("Root node of space '" + spaceParentPath + "' doesn't exist");
        }
        Node parentNode = (Node)session.getItem(spaceParentPath);
        if (!parentNode.hasNode(ACTIVITY_FOLDER_UPLOAD_NAME)) {
            Node activityFolder = parentNode.addNode(ACTIVITY_FOLDER_UPLOAD_NAME);
            activityFolder.addMixin("exo:hiddenable");
            session.save();
        }
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }
}

