/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.attachments.model;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.pdfbox.io.IOUtils;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;

public class ActivityFilesDownloadResource
extends DownloadResource {
    private static final Log LOG = ExoLogger.getLogger(ActivityFilesDownloadResource.class);
    private NodeLocation[] nodeLocations;

    public ActivityFilesDownloadResource(NodeLocation[] nodelocations) {
        super(ActivityFilesDownloadResource.getMimetype(nodelocations));
        this.nodeLocations = nodelocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (this.nodeLocations == null || this.nodeLocations.length == 0) {
            return null;
        }
        if (this.nodeLocations.length == 1) {
            NodeLocation nodeLocation = this.nodeLocations[0];
            Node node = NodeLocation.getNodeByLocation(nodeLocation);
            try {
                Node contentNode;
                if (node.isNodeType("nt:file") && node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) {
                    return contentNode.getProperty("jcr:data").getStream();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error getting inputstream of file content", e);
            }
            return null;
        }
        File resultFile = File.createTempFile("activity_files", ".zip");
        ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream(resultFile);
        try {
            zipOutputStream.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
            zipOutputStream.setEncoding("UTF-8");
            for (NodeLocation nodeLocation : this.nodeLocations) {
                Node contentNode;
                Node node = NodeLocation.getNodeByLocation(nodeLocation);
                if (!node.isNodeType("nt:file") || !node.hasNode("jcr:content") || !(contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) continue;
                String fileName = node.hasProperty("exo:name") ? node.getProperty("exo:name").getString() : node.getName();
                ZipArchiveEntry entry = new ZipArchiveEntry(fileName);
                zipOutputStream.putArchiveEntry(entry);
                try (InputStream inputStream = null;){
                    inputStream = contentNode.getProperty("jcr:data").getStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                }
                zipOutputStream.closeArchiveEntry();
            }
        }
        catch (Exception exp) {
            IOUtils.closeQuietly((Closeable)zipOutputStream);
            resultFile.delete();
            LOG.error((Object)"An error occurred when generating the ZIP file", (Throwable)exp);
            throw new RuntimeException("An error occurred when generating the ZIP file", exp);
        }
        finally {
            IOUtils.closeQuietly((Closeable)zipOutputStream);
        }
        return new FileInputStream(resultFile);
    }

    private static String getMimetype(NodeLocation[] nodeLocations) {
        if (nodeLocations == null || nodeLocations.length == 0) {
            return null;
        }
        if (nodeLocations.length == 1) {
            NodeLocation nodeLocation = nodeLocations[0];
            Node node = NodeLocation.getNodeByLocation(nodeLocation);
            try {
                Node contentNode;
                if (node.isNodeType("nt:file") && node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:mimeType")) {
                    return contentNode.getProperty("jcr:mimeType").getString();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error getting mimetype of file", e);
            }
            return "application/octet-stream";
        }
        return "application/zip";
    }
}

