/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.ckeditor;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class HTMLUploadImageProcessor {
    private static final Log LOG = ExoLogger.getLogger(HTMLUploadImageProcessor.class);
    private static final Pattern UPLOAD_ID_PATTERN = Pattern.compile("uploadId=(([0-9]|[a-f]|[A-F])*)");
    public static final String IP_REGEX = "(((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)";
    public static final String URL_OR_URI_REGEX = "^(((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?((((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?)?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$";
    private static final Pattern UPLOAD_URL_PATTERN = Pattern.compile("^(((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?((((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?)?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$");
    private PortalContainer portalContainer;
    private UploadService uploadService;
    private RepositoryService repositoryService;
    private String repositoryName;
    private LinkManager linkManager;

    public HTMLUploadImageProcessor(PortalContainer portalContainer, UploadService uploadService, RepositoryService repositoryService, LinkManager linkManager) {
        this.portalContainer = portalContainer;
        this.uploadService = uploadService;
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
    }

    public String processImages(String content, Node parentNode, String imagesSubFolderPath) throws Exception {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        HashSet<String> processedUploads = new HashSet<String>();
        HashMap<String, String> urlToReplaces = new HashMap<String, String>();
        Matcher matcher = UPLOAD_ID_PATTERN.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        if (parentNode == null) {
            throw new IllegalArgumentException("Container node for uploaded processed images in HTML content must not be null");
        }
        Node imagesFolderNode = parentNode;
        if (StringUtils.isNotEmpty((CharSequence)imagesSubFolderPath)) {
            for (String folder : imagesSubFolderPath.split("/")) {
                if (StringUtils.isBlank((CharSequence)folder)) continue;
                if (imagesFolderNode.hasNode(folder)) {
                    if (!(imagesFolderNode = imagesFolderNode.getNode(folder)).isNodeType("exo:symlink")) continue;
                    imagesFolderNode = this.linkManager.getTarget(imagesFolderNode);
                    continue;
                }
                imagesFolderNode = imagesFolderNode.isNodeType("exo:symlink") ? this.linkManager.getTarget(imagesFolderNode).getNode(folder) : imagesFolderNode.addNode(folder, "nt:unstructured");
            }
        }
        String processedContent = content;
        do {
            UploadResource uploadedResource;
            String uploadId;
            if (processedUploads.contains(uploadId = matcher.group(matcher.groupCount() - 1)) || (uploadedResource = this.uploadService.getUploadResource(uploadId)) == null) continue;
            String fileName = uploadedResource.getFileName();
            int i = 1;
            String originalFileName = fileName;
            while (imagesFolderNode.hasNode(fileName)) {
                if (originalFileName.contains(".")) {
                    int indexOfPoint = originalFileName.indexOf(".");
                    fileName = originalFileName.substring(0, indexOfPoint) + "(" + i + ")" + originalFileName.substring(indexOfPoint);
                } else {
                    fileName = originalFileName + "(" + i + ")";
                }
                ++i;
            }
            fileName = Text.escapeIllegalJcrChars((String)fileName);
            fileName = Utils.cleanName((String)fileName);
            Node imageNode = imagesFolderNode.addNode(fileName, "nt:file");
            Node resourceNode = imageNode.addNode("jcr:content", "nt:resource");
            resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
            resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
            String fileDiskLocation = uploadedResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
                resourceNode.setProperty("jcr:data", (InputStream)inputStream);
                resourceNode.getSession().save();
                parentNode.getSession().save();
            }
            this.uploadService.removeUploadResource(uploadId);
            int uploadIdIndex = matcher.start();
            String urlToReplace = HTMLUploadImageProcessor.getURLToReplace(processedContent, uploadId, uploadIdIndex);
            if (!UPLOAD_URL_PATTERN.matcher(urlToReplace).matches()) {
                LOG.warn("Unrecognized URL to replace in activity body {}", new Object[]{urlToReplace});
                continue;
            }
            String fileURI = this.getJcrURI(imageNode);
            if (!StringUtils.isNotBlank((CharSequence)urlToReplace)) continue;
            urlToReplaces.put(urlToReplace, fileURI);
            processedUploads.add(uploadId);
        } while (matcher.find());
        processedContent = this.replaceUrl(content, urlToReplaces);
        return processedContent;
    }

    private String replaceUrl(String body, Map<String, String> urlToReplaces) {
        for (String url : urlToReplaces.keySet()) {
            while (body.contains(url)) {
                body = body.replace(url, urlToReplaces.get(url));
            }
        }
        return body;
    }

    private String getJcrURI(Node imageNode) throws RepositoryException {
        if (!imageNode.isNodeType("mix:referenceable")) {
            imageNode.addMixin("mix:referenceable");
        }
        return "/" + this.portalContainer.getName() + "/" + this.portalContainer.getRestContextName() + "/images/" + this.getRepositoryName() + "/" + imageNode.getSession().getWorkspace().getName() + "/" + imageNode.getUUID();
    }

    private static String getURLToReplace(String body, String uploadId, int uploadIdIndex) {
        int srcBeginIndex = body.lastIndexOf("\"", uploadIdIndex);
        int srcEndIndex = -1;
        if (srcBeginIndex < 0) {
            srcBeginIndex = body.lastIndexOf("'", uploadIdIndex);
            if (srcBeginIndex < 0) {
                LOG.warn((Object)("Cannot find src start delimiter in URL for uploadId " + uploadId + " ignore URL replacing"));
            } else {
                srcEndIndex = body.indexOf("'", srcBeginIndex + 1);
            }
        } else {
            srcEndIndex = body.indexOf("\"", srcBeginIndex + 1);
        }
        String urlToReplace = null;
        if (srcEndIndex < 0) {
            LOG.warn((Object)("Cannot find src end delimiter in URL for uploadId " + uploadId + " ignore URL replacing"));
        } else {
            urlToReplace = body.substring(srcBeginIndex + 1, srcEndIndex);
        }
        return urlToReplace;
    }

    public String getRepositoryName() {
        if (this.repositoryName == null) {
            try {
                this.repositoryName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            }
            catch (RepositoryException e) {
                this.repositoryName = this.repositoryService.getConfig().getDefaultRepositoryName();
            }
        }
        return this.repositoryName;
    }
}

