/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.FileUIActivity;
import org.json.JSONException;
import org.json.JSONObject;

public class FileUIActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(FileUIActivityBuilder.class);
    private Pattern patternLink;

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        String HTML_A_HREF_TAG_PATTERN = "^<a\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]>" + (String)activity.getTemplateParams().get("docTitle") + "<\\/a>$))";
        FileUIActivity fileActivity = (FileUIActivity)uiActivity;
        if (activity.getTemplateParams() == null) {
            this.saveToNewDataFormat(activity);
        }
        Map templateParams = activity.getTemplateParams();
        fileActivity.setLinkSource((String)templateParams.get("link"));
        fileActivity.setLinkTitle((String)templateParams.get("title"));
        fileActivity.setLinkImage((String)templateParams.get("image"));
        fileActivity.setLinkDescription((String)templateParams.get("description"));
        fileActivity.setEmbedHtml((String)templateParams.get("html"));
        this.patternLink = Pattern.compile(HTML_A_HREF_TAG_PATTERN);
        if (activity.getTemplateParams() != null) {
            fileActivity.setUIActivityData(activity.getTemplateParams());
        }
        if (activity.getTemplateParams() != null && StringUtils.isNotBlank((String)((String)templateParams.get("MESSAGE")))) {
            fileActivity.setMessage((String)templateParams.get("MESSAGE"));
        } else if (activity.getTemplateParams() != null && StringUtils.isNotBlank((String)((String)activity.getTemplateParams().get("description"))) || !this.patternLink.matcher(activity.getTitle()).find()) {
            fileActivity.setMessage(activity.getTitle());
        } else {
            fileActivity.setMessage(null);
        }
        if (fileActivity.getFilesCount() > 0) {
            RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            ManageableRepository manageRepo = null;
            Node contentNode = null;
            try {
                manageRepo = repositoryService.getCurrentRepository();
                SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
                for (String ws : manageRepo.getWorkspaceNames()) {
                    try {
                        for (int i = 0; i < fileActivity.getFilesCount(); ++i) {
                            if (StringUtils.isEmpty((String)fileActivity.getNodeUUID(i))) {
                                String contentLink = fileActivity.getContentLink(i);
                                String _ws = contentLink.split("/")[0];
                                String _repo = contentLink.split("/")[1];
                                String nodePath = contentLink.replace(_ws + "/" + _repo, "");
                                contentNode = (Node)sessionProvider.getSession(ws, manageRepo).getItem(nodePath);
                                fileActivity.setContentNode(contentNode, i);
                            } else {
                                contentNode = sessionProvider.getSession(ws, manageRepo).getNodeByUUID(fileActivity.getNodeUUID(i));
                            }
                            fileActivity.setContentNode(contentNode, i);
                        }
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
            }
            catch (RepositoryException re) {
                LOG.error((Object)"Can not get the repository. ", (Throwable)re);
            }
        }
    }

    private void saveToNewDataFormat(ExoSocialActivity activity) {
        try {
            JSONObject jsonObj = new JSONObject(activity.getTitle());
            StringBuilder linkTitle = new StringBuilder("Shared a link:");
            linkTitle.append(" <a href=\"${").append("link").append("}\">${").append("title").append("} </a>");
            activity.setTitle(linkTitle.toString());
            HashMap<String, String> templateParams = new HashMap<String, String>();
            templateParams.put("link", jsonObj.getString("link"));
            templateParams.put("title", jsonObj.getString("title"));
            templateParams.put("image", jsonObj.getString("image"));
            templateParams.put("description", jsonObj.getString("description"));
            templateParams.put("comment", jsonObj.getString("comment"));
            activity.setTemplateParams(templateParams);
            ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).saveActivityNoReturn(activity);
        }
        catch (JSONException je) {
            LOG.error((Object)"Error with activity's title data");
        }
        catch (ActivityStorageException ase) {
            LOG.warn((Object)"Could not save new data format for document activity.", (Throwable)ase);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error  to save document activity.", (Throwable)e);
        }
    }
}

