/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import java.io.File;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.Version;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wcm.ext.component.activity.ECMSActivityFileStoragePlugin;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ECMSActivityFileStoragePluginTest {
    private static String TEXT_PLAIN = "text/plain";
    @Mock
    UploadService uploadService;
    @Mock
    SessionProviderService sessionProviderService;
    @Mock
    SpaceService spaceService;
    @Mock
    RepositoryService repositoryService;
    @Mock
    NodeHierarchyCreator nodeHierarchyCreator;
    @Mock
    SessionProvider sessionProvider;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    Session session;
    @Mock
    AutoVersionService autoVersionService;

    @Test
    public void storeAttachments() throws Exception {
        ConversationState.setCurrent((ConversationState)new ConversationState(new Identity("root")));
        InitParams initParams = new InitParams();
        ValueParam datasource = new ValueParam();
        datasource.setName("datasource");
        datasource.setValue("jcr");
        ValueParam priority = new ValueParam();
        priority.setName("priority");
        priority.setValue("1");
        initParams.addParameter((Parameter)datasource);
        initParams.addParameter((Parameter)priority);
        ECMSActivityFileStoragePlugin ecmsActivityFileStoragePlugin = new ECMSActivityFileStoragePlugin(this.spaceService, this.nodeHierarchyCreator, this.repositoryService, this.uploadService, this.sessionProviderService, initParams, this.autoVersionService);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("test");
        activity.setStreamOwner("root");
        org.exoplatform.social.core.identity.model.Identity streamOwner = new org.exoplatform.social.core.identity.model.Identity("organization", "root");
        streamOwner.setId("root");
        ActivityFile activityFile = new ActivityFile();
        activityFile.setUploadId("1234");
        activityFile.setName("testFileUpload");
        UploadResource uploadResource = new UploadResource("1234");
        uploadResource.setFileName("testFileUpload");
        File file = File.createTempFile("testFileUpload", ".xml");
        uploadResource.setStoreLocation(file.getPath());
        uploadResource.setMimeType(TEXT_PLAIN);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(Mockito.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.sessionProviderService.getSessionProvider(Mockito.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getName()).thenReturn((Object)"workspace");
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)Mockito.any(), (ManageableRepository)Mockito.any())).thenReturn((Object)this.session);
        Node userNode = (Node)Mockito.mock(Node.class);
        Node parentNode = (Node)Mockito.mock(Node.class);
        Node parentUploadNode = (Node)Mockito.mock(Node.class);
        Node node = (Node)Mockito.mock(Node.class);
        Node resourceNode = (Node)Mockito.mock(Node.class);
        NodeDefinition nodeDefinition = (NodeDefinition)Mockito.mock(NodeDefinition.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.nodeHierarchyCreator.getUserNode((SessionProvider)Mockito.any(), (String)Mockito.any())).thenReturn((Object)userNode);
        Mockito.when((Object)this.nodeHierarchyCreator.getJcrPath((String)Mockito.any())).thenReturn((Object)"/Users");
        Mockito.when((Object)userNode.hasNode((String)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)userNode.getNode((String)Mockito.any())).thenReturn((Object)parentNode);
        Mockito.when((Object)parentNode.hasNode((String)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)parentNode.getNode((String)Mockito.any())).thenReturn((Object)parentUploadNode);
        Mockito.when((Object)parentUploadNode.getDefinition()).thenReturn((Object)nodeDefinition);
        Mockito.when((Object)parentUploadNode.addNode((String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)node);
        Mockito.when((Object)node.addNode((String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)resourceNode);
        Mockito.when((Object)this.uploadService.getUploadResource((String)Mockito.any())).thenReturn((Object)uploadResource);
        Mockito.when((Object)this.session.getItem((String)Mockito.any())).thenReturn((Object)node);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/test/node_B/node_1");
        Mockito.when((Object)resourceNode.getProperty((String)Mockito.any())).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"testProperty");
        Mockito.when((Object)node.isNodeType((String)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)this.autoVersionService.autoVersion(node)).thenReturn((Object)((Version)Mockito.any()));
        ecmsActivityFileStoragePlugin.storeAttachments((ExoSocialActivity)activity, streamOwner, new ActivityFile[]{activityFile});
        ((UploadService)Mockito.verify((Object)this.uploadService, (VerificationMode)Mockito.times((int)1))).removeUploadResource((String)Mockito.any());
        ((UploadService)Mockito.verify((Object)this.uploadService, (VerificationMode)Mockito.times((int)1))).getUploadResource((String)Mockito.any());
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).save();
        ((AutoVersionService)Mockito.verify((Object)this.autoVersionService, (VerificationMode)Mockito.times((int)1))).autoVersion((Node)Mockito.any());
    }
}

