/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.activity.processor;

import java.util.HashMap;
import javax.jcr.Node;
import org.exoplatform.ecms.activity.processor.ActivityAttachmentProcessor;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityAttachmentProcessorTest {
    @Mock
    private ActivityAttachmentProcessor activityAttachmentProcessor;

    @Test
    public void processActivity() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType("sharefiles:spaces");
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("workspace", "collaboration");
        templateParams.put("author", "root");
        templateParams.put("permission", "read");
        templateParams.put("nodePath", "/Groups/spaces/new/Documents/Shared/sample.pdf");
        templateParams.put("docTitle", "sample.pdf");
        templateParams.put("mimeType", "application/pdf");
        templateParams.put("message", "");
        templateParams.put("repository", "repository");
        templateParams.put("contentName", "sample.pdf");
        templateParams.put("nodeUUID", "736ec0d07f0001015e91bad4c1d582e1");
        templateParams.put("id", "736ec0d07f0001015e91bad4c1d582e1");
        activity.setTemplateParams(templateParams);
        NodeLocation nodeLocation = new NodeLocation((String)templateParams.get("repository"), (String)templateParams.get("workspace"), (String)templateParams.get("nodePath"), (String)templateParams.get("nodeUUID"), true);
        Node currentNode = (Node)Mockito.mock(Node.class);
        ((ActivityAttachmentProcessor)Mockito.doCallRealMethod().when((Object)this.activityAttachmentProcessor)).processActivity((ExoSocialActivity)activity);
        MockedStatic NODE_LOCATION = Mockito.mockStatic(NodeLocation.class);
        NODE_LOCATION.when(() -> NodeLocation.getNodeByLocation((NodeLocation)((NodeLocation)ArgumentMatchers.refEq((Object)nodeLocation, (String[])new String[0])))).thenReturn((Object)currentNode);
        this.activityAttachmentProcessor.processActivity((ExoSocialActivity)activity);
        Assert.assertEquals((long)1L, (long)activity.getFiles().size());
    }
}

