/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.test;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecms.test.DumpThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.security.ConversationState;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/ecms-test-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/mock-rest-configuration.xml")})
public abstract class BaseECMSTestCase
extends BaseExoTestCase {
    protected static Log log = ExoLogger.getLogger((String)BaseECMSTestCase.class.getName());
    protected PortalContainer container;
    protected ProviderBinder providers;
    protected ResourceBinder binder;
    protected RequestHandlerImpl requestHandler;
    protected OrganizationService orgService;
    protected CredentialsImpl credentials;
    protected RepositoryService repositoryService;
    protected SessionProvider sessionProvider;
    protected Session session;
    protected ManageableRepository repository;
    protected SessionProviderService sessionProviderService_;
    protected final String REPO_NAME = "repository";
    protected final String DMSSYSTEM_WS = "dms-system";
    protected final String SYSTEM_WS = "system";
    protected final String COLLABORATION_WS = "collaboration";

    public void setUp() throws Exception {
        this.begin();
        this.initServices();
    }

    public void tearDown() throws Exception {
        this.removeAllData();
        this.end();
    }

    private void removeAllData() {
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    public void applySystemSession() throws RepositoryConfigurationException, RepositoryException {
        System.setProperty("gatein.tenant.repository.name", "repository");
        this.container = PortalContainer.getInstance();
        this.repositoryService.setCurrentRepositoryName("repository");
        this.repository = this.repositoryService.getCurrentRepository();
        this.closeOldSession();
        this.sessionProvider = this.sessionProviderService_.getSystemSessionProvider(null);
        this.session = this.sessionProvider.getSession("collaboration", this.repository);
        this.sessionProvider.setCurrentRepository(this.repository);
        this.sessionProvider.setCurrentWorkspace("collaboration");
    }

    public void applyUserSession(String username, String password, String workspaceName) throws RepositoryConfigurationException, RepositoryException {
        this.repositoryService.setCurrentRepositoryName("repository");
        this.repository = this.repositoryService.getCurrentRepository();
        this.credentials = new CredentialsImpl(username, password.toCharArray());
        this.closeOldSession();
        this.session = (SessionImpl)this.repository.login((Credentials)this.credentials, workspaceName);
        ((DumpThreadLocalSessionProviderService)this.sessionProviderService_).applyUserSession(this.session);
    }

    private void initServices() {
        this.container = PortalContainer.getInstance();
        this.orgService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        this.repositoryService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
        this.binder = (ResourceBinder)this.container.getComponentInstanceOfType(ResourceBinder.class);
        this.requestHandler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ProviderBinder.setInstance((ProviderBinder)new ProviderBinder());
        this.providers = ProviderBinder.getInstance();
        ApplicationContextImpl.setCurrent((ApplicationContext)new ApplicationContextImpl(null, null, this.providers));
        this.binder.clear();
        this.sessionProviderService_ = (SessionProviderService)this.container.getComponentInstanceOfType(SessionProviderService.class);
        String loginConf = ((Object)((Object)this)).getClass().getResource("/conf/standalone/login.conf").toString();
        System.setProperty("java.security.auth.login.config", loginConf);
        try {
            this.applySystemSession();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            BaseECMSTestCase.fail();
        }
    }

    protected void endSession() {
        this.sessionProviderService_.removeSessionProvider(null);
        ConversationState.setCurrent(null);
    }

    private void closeOldSession() {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
            ((DumpThreadLocalSessionProviderService)this.sessionProviderService_).applyUserSession(null);
        }
    }
}

