/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.test;

import java.io.StringWriter;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.ecms.test.BaseECMSResourceTestCase;
import org.exoplatform.ecms.test.mock.MockRestService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.IdentityConstants;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/ecms-test-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/mock-rest-configuration.xml")})
public class DummyECMSTestCase
extends BaseECMSResourceTestCase {
    private final String MOCK_RESOURCE_URL = "/mock/guest";

    public void setUp() throws Exception {
        super.setUp();
        MockRestService restService = (MockRestService)this.container.getComponentInstanceOfType(MockRestService.class);
        this.binder.addResource((Object)restService, null);
        this.applySystemSession();
    }

    public void testInitServices() throws Exception {
        DummyECMSTestCase.assertNotNull((Object)this.repositoryService);
        DummyECMSTestCase.assertEquals((String)this.repositoryService.getDefaultRepository().getConfiguration().getName(), (String)"repository");
        DummyECMSTestCase.assertEquals((String)this.repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName(), (String)"collaboration");
        DummyECMSTestCase.assertNotNull((Object)this.container);
        DummyECMSTestCase.assertNotNull((Object)this.getService(LocaleConfigService.class));
    }

    public void testInitializedServices() {
        DummyECMSTestCase.assertNotNull((Object)this.container);
        DummyECMSTestCase.assertNotNull((Object)this.orgService);
        DummyECMSTestCase.assertNotNull((Object)this.repositoryService);
        DummyECMSTestCase.assertNotNull((Object)this.sessionProviderService_);
    }

    public void testApplySession() throws RepositoryConfigurationException, RepositoryException {
        DummyECMSTestCase.assertNotNull((Object)this.session);
        DummyECMSTestCase.assertNotNull((Object)this.repository);
        DummyECMSTestCase.assertEquals((String)IdentityConstants.SYSTEM, (String)this.session.getUserID());
        this.applyUserSession("john", "gtn", "collaboration");
        DummyECMSTestCase.assertNotNull((Object)this.session);
        DummyECMSTestCase.assertEquals((String)"john", (String)this.session.getUserID());
        this.applyUserSession("john", "gtn", "dms-system");
        DummyECMSTestCase.assertNotNull((Object)this.session);
        DummyECMSTestCase.assertEquals((String)"john", (String)this.session.getUserID());
    }

    public void testAchieveResource() throws Exception {
        StringWriter writer = new StringWriter().append("name=guest");
        byte[] data = writer.getBuffer().toString().getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/x-www-form-urlencoded".toString());
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        ContainerResponse response = this.service("POST".toString(), "/mock/guest", "", (MultivaluedMap)h, data);
        DummyECMSTestCase.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        DummyECMSTestCase.assertEquals((String)"Registed guest", (String)response.getEntity().toString());
        response = this.service("GET".toString(), "/mock/guest?name=guest", "", null, null);
        DummyECMSTestCase.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        DummyECMSTestCase.assertEquals((String)"Hello guest", (String)response.getEntity().toString());
        response = this.service("DELETE".toString(), "/mock/guest?name=guest", "", null, null);
        DummyECMSTestCase.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        DummyECMSTestCase.assertEquals((String)"Removed guest", (String)response.getEntity().toString());
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }
}

