/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.sanitization;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class SanitizationUpgradePlugin
extends UpgradeProductPlugin {
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repoService_;
    private ManageViewService viewService_;
    private static final Log LOG = ExoLogger.getLogger((String)SanitizationUpgradePlugin.class.getName());

    public SanitizationUpgradePlugin(RepositoryService repoService, DMSConfiguration dmsConfiguration, ManageViewService viewService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
        this.viewService_ = viewService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        this.migrateViews();
        this.migrateViewTemplates();
        this.migrateDrives();
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }

    private void migrateViews() {
        block7: {
            try {
                Session session = WCMCoreUtils.getSystemSessionProvider().getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
                String[] oldViewTemplates = new String[]{"ListView", "ContentView", "ThumbnailsView", "IconView", "TimelineView", "CoverFlow", "SystemView", "SlideShowView"};
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"=====Start migrate data for all user views=====");
                }
                String statement = "SELECT * FROM exo:view ORDER BY exo:name DESC";
                QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
                NodeIterator nodeIter = result.getNodes();
                while (nodeIter.hasNext()) {
                    Node viewNode = nodeIter.nextNode();
                    String template = viewNode.getProperty("exo:template").getString();
                    String templateName = StringUtils.substringAfterLast((String)template, (String)"/");
                    for (String oldTemp : oldViewTemplates) {
                        if (!templateName.equals(oldTemp)) continue;
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)(" * Removing the old view " + viewNode.getName() + ""));
                        }
                        viewNode.remove();
                    }
                }
                session.save();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"=====Completed the migration data for user views=====");
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)"An unexpected error occurs when migrate views", (Throwable)e);
            }
        }
    }

    private void migrateViewTemplates() {
        block6: {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"=====Start migrate data for all user views template=====");
                }
                Session session = WCMCoreUtils.getSystemSessionProvider().getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
                String[] oldViewTemplates = new String[]{"ListView", "ContentView", "ThumbnailsView", "IconView", "TimelineView", "CoverFlow", "SystemView", "SlideShowView"};
                List templates = this.viewService_.getAllTemplates("ecmExplorerTemplates", WCMCoreUtils.getSystemSessionProvider());
                block2: for (Node template : templates) {
                    for (String oldViewTemp : oldViewTemplates) {
                        if (!template.getName().equals(oldViewTemp)) continue;
                        LOG.info((Object)(" * Removing the old view template " + template.getName() + ""));
                        template.remove();
                        continue block2;
                    }
                }
                session.save();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"=====Completed the migration data for user views template=====");
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"An unexpected error occurs when migrate view templates", (Throwable)e);
            }
        }
    }

    private void migrateDrives() {
        block20: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"=====Start migrate data for drives=====");
            }
            try {
                Session session = WCMCoreUtils.getSystemSessionProvider().getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
                String statement = "SELECT * FROM exo:drive ORDER BY exo:name DESC";
                QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
                NodeIterator nodeIter = result.getNodes();
                while (nodeIter.hasNext()) {
                    String path;
                    Node drive = nodeIter.nextNode();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)(" * Migrating the drive " + drive.getName() + ""));
                    }
                    if ((path = drive.getProperty("exo:path").getString()).equals("/sites content/live")) {
                        drive.setProperty("exo:path", "/sites");
                        drive.setProperty("exo:views", "Web");
                        continue;
                    }
                    if (path.equals("/Groups${groupId}")) {
                        path = path.replace("/Groups${groupId}", "/Groups${groupId}/Documents");
                        drive.setProperty("exo:path", path);
                        drive.setProperty("exo:views", "List, Icons");
                        continue;
                    }
                    if (drive.getName().equals("collaboration") && path.equals("/")) {
                        drive.remove();
                        continue;
                    }
                    if (drive.getName().equals("Trash") && path.equals("/Trash")) {
                        drive.setProperty("exo:views", "Admin");
                        continue;
                    }
                    if (drive.getName().equals("acme-category")) {
                        drive.remove();
                        continue;
                    }
                    if (drive.getName().equals("Private") || drive.getName().equals("Public")) {
                        drive.remove();
                        continue;
                    }
                    if (drive.getProperty("exo:workspace").getString().equals("dms-system") && path.equals("/")) {
                        drive.remove();
                        continue;
                    }
                    String views = drive.getProperty("exo:views").getString();
                    String[] arrView = new String[]{};
                    arrView = views.indexOf(",") > -1 ? views.split(",") : new String[]{views};
                    StringBuilder strViews = new StringBuilder();
                    for (String view : arrView) {
                        if (strViews.length() > 0) {
                            strViews.append(", ");
                        }
                        if ((view = view.trim()).equals("a_timeline-view")) {
                            strViews.append("List");
                            continue;
                        }
                        if (view.equals("b_list-view")) {
                            strViews.append("List");
                            continue;
                        }
                        if (view.equals("c_icon-view")) {
                            strViews.append("Icons");
                            continue;
                        }
                        if (view.equals("d_cover-flow")) {
                            strViews.append("Icons");
                            continue;
                        }
                        if (view.equals("e_admin-view")) {
                            strViews.append("Admin");
                            continue;
                        }
                        strViews.append(view);
                    }
                    drive.setProperty("exo:views", strViews.toString());
                }
                session.save();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"=====Completed the migration data for drives=====");
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block20;
                LOG.error((Object)"An unexpected error occurs when migrate drives", (Throwable)e);
            }
        }
    }
}

