/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.views;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeExoViewNodeTypePlugin
extends UpgradeProductPlugin {
    private static final String EXO_HIDE_EXPLORER_PANEL = "exo:hideExplorerPanel";
    private static final String EXO_VIEW = "exo:view";
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repoService_;
    private static final Log LOG = ExoLogger.getLogger((String)UpgradeExoViewNodeTypePlugin.class.getName());

    public UpgradeExoViewNodeTypePlugin(RepositoryService repoService, DMSConfiguration dmsConfiguration, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Session session = sessionProvider.getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            NodeTypeValue exoView = nodeTypeManager.getNodeTypeValue(EXO_VIEW);
            List propertyDefinitionList = exoView.getDeclaredPropertyDefinitionValues();
            boolean propertyExists = false;
            for (PropertyDefinitionValue propertyDefinition : propertyDefinitionList) {
                if (!EXO_HIDE_EXPLORER_PANEL.equals(propertyDefinition.getName())) continue;
                propertyExists = true;
                break;
            }
            if (!propertyExists) {
                ArrayList<String> defaultValues = new ArrayList<String>();
                defaultValues.add("false");
                propertyDefinitionList.add(new PropertyDefinitionValue(EXO_HIDE_EXPLORER_PANEL, true, true, 1, false, defaultValues, false, 6, new ArrayList()));
                exoView.setDeclaredPropertyDefinitionValues(propertyDefinitionList);
                nodeTypeManager.registerNodeType(exoView, 4);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Add new property definition 'exo:hideExplorerPanel' for node type definition 'exo:view' successfully!");
            }
            String statement = "SELECT * FROM exo:view where exo:hideExplorerPanel IS NULL";
            Query query = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            NodeIterator iter = query.execute().getNodes();
            while (iter.hasNext()) {
                Node viewNode = iter.nextNode();
                viewNode.setProperty(EXO_HIDE_EXPLORER_PANEL, false);
                viewNode.save();
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Add new property value 'exo:hideExplorerPanel' for node type 'exo:view' successfully!");
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs when add new property 'exo:hideExplorerPanel' for node type 'exo:view'!", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

